/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.basic;

import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class AutoBackupTimerAttr
implements XMLable {
    public static final String XML_TAG = "AutoBackupTimerAttr";
    private static final String DEFAULT_DATE = "2016.01.01 22:00:00";
    public static final int DEFAULT_FREQ = BackupFrequency.ONE_WEEK.getValue();
    private String autoBackupTaskName;
    private boolean isAutoBackupStart;
    private String autoBackupNextStartDate;
    private long autoBackupFrequency;

    public boolean isAutoBackupStart() {
        return this.isAutoBackupStart;
    }

    public void setIsAutoBackupStart(boolean bl) {
        this.isAutoBackupStart = bl;
    }

    public String getAutoBackupNextStartDate() {
        return this.autoBackupNextStartDate;
    }

    public void setAutoBackupNextStartDate(String string) {
        this.autoBackupNextStartDate = string;
    }

    public String getAutoBackupTaskName() {
        return this.autoBackupTaskName;
    }

    public void setAutoBackupTaskName(String string) {
        this.autoBackupTaskName = string;
    }

    public long getAutoBackupFrequency() {
        return this.autoBackupFrequency;
    }

    public void setAutoBackupFrequency(long l) {
        this.autoBackupFrequency = l;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.autoBackupTaskName = xMLableReader.getAttrAsString("name", "");
            this.isAutoBackupStart = xMLableReader.getAttrAsBoolean("isStart", true);
            this.autoBackupNextStartDate = xMLableReader.getAttrAsString("nextStartDate", DEFAULT_DATE);
            this.autoBackupFrequency = xMLableReader.getAttrAsLong("frequency", (long)DEFAULT_FREQ);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("name", this.autoBackupTaskName);
        xMLPrintWriter.attr("isStart", this.isAutoBackupStart);
        xMLPrintWriter.attr("nextStartDate", this.autoBackupNextStartDate);
        xMLPrintWriter.attr("frequency", this.autoBackupFrequency);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BackupFrequency {
        ONE_DAY(1),
        ONE_WEEK(7),
        ONE_MONTH(30),
        THREE_MONTHS(90),
        SIX_MONTHS(180);

        public int value;

        private BackupFrequency(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

