/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.vanchart;

import com.fr.base.background.ImageBackground;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.TopDefinitionProvider;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.TopDefinition;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.plugin.chart.attr.VanChartTitle;
import com.fr.plugin.chart.attr.VanChartTools;
import com.fr.plugin.chart.attr.VanChartZoom;
import com.fr.plugin.chart.data.VanChartMoreNameCDDefinition;
import com.fr.plugin.chart.data.VanChartNormalReportDataDefinition;
import com.fr.plugin.chart.data.VanChartOneValueCDDefinition;
import com.fr.plugin.chart.data.model.LargeModel;
import com.fr.plugin.chart.vanchart.VanChartGlyph;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.List;

public class VanChart
extends Chart {
    private static final long serialVersionUID = 8606596488760033141L;
    private VanChartTools vanChartTools = new VanChartTools();
    private VanChartZoom vanChartZoom = new VanChartZoom();

    public VanChart() {
        this.setTitle(new VanChartTitle());
        this.setBorderColor(new Color(238, 238, 238));
        this.setBorderStyle(0);
        this.setWrapperName("VanChartWrapper");
    }

    public VanChart(Plot plot) {
        this.setPlot(plot);
        this.setTitle(new VanChartTitle());
        this.setBorderColor(new Color(238, 238, 238));
        this.setBorderStyle(0);
        this.setWrapperName("VanChartWrapper");
    }

    public void setVanChartTools(VanChartTools vanChartTools) {
        this.vanChartTools = vanChartTools;
    }

    public VanChartTools getVanChartTools() {
        return this.vanChartTools;
    }

    public void setVanChartZoom(VanChartZoom vanChartZoom) {
        this.vanChartZoom = vanChartZoom;
    }

    public VanChartZoom getVanChartZoom() {
        return this.vanChartZoom;
    }

    public BaseChartGlyph createGlyph(ChartData chartData) {
        VanChartGlyph vanChartGlyph = new VanChartGlyph();
        vanChartGlyph.setGeneralInfo((GeneralInfo)this);
        vanChartGlyph.setVanChartTools(this.vanChartTools);
        if (this.getPlot().isSupportZoomDirection()) {
            vanChartGlyph.setVanChartZoom(this.vanChartZoom);
        }
        vanChartGlyph.setJSDraw(this.isJSDraw());
        this.createTitleGlyph4ChartGlyph(vanChartGlyph);
        PlotGlyph plotGlyph = this.createPlotGlyph4ChartGlyph(chartData, vanChartGlyph);
        this.createLegendGlyph(vanChartGlyph, plotGlyph);
        this.createDataSheetGlyph4ChartGlyph(vanChartGlyph, plotGlyph);
        vanChartGlyph.setWrapperName(this.getWrapperName());
        vanChartGlyph.setRequiredJS(this.getRequiredJS());
        return vanChartGlyph;
    }

    protected void readChartXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Title4VanChart")) {
                this.setTitle(new VanChartTitle());
                xMLableReader.readXMLObject((XMLReadable)this.getTitle());
            } else if (string.equals("Plot")) {
                this.setPlot((Plot)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader));
            } else if (string.equals("ChartAttr")) {
                this.setJSDraw(xMLableReader.getAttrAsBoolean("isJSDraw", true));
                this.setStyleGlobal(xMLableReader.getAttrAsBoolean("isStyleGlobal", false));
            } else if (ComparatorUtils.equals((Object)string, (Object)"ChartDefinition")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        VanChart.this.setFilterDefinition((TopDefinitionProvider)VanChart.readDefinition(xMLableReader));
                    }
                });
            } else if (string.equals("tools")) {
                this.setVanChartTools((VanChartTools)xMLableReader.readXMLObject((XMLReadable)new VanChartTools()));
                this.changeImageLayout((GeneralInfo)this);
                this.changeImageLayout((GeneralInfo)this.getPlot());
            } else if (string.equals("VanChartZoom")) {
                this.setVanChartZoom((VanChartZoom)xMLableReader.readXMLObject((XMLReadable)new VanChartZoom()));
            } else if (ComparatorUtils.equals((Object)string, (Object)"DataProcessor")) {
                this.setDataProcessor((DataProcessor)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader));
            }
        }
    }

    public static TopDefinition readDefinition(XMLableReader xMLableReader) {
        Object object;
        String string = xMLableReader.getTagName();
        if ("OneValueCDDefinition".equals(string)) {
            object = new VanChartOneValueCDDefinition();
        } else if ("MoreNameCDDefinition".equals(string)) {
            object = new VanChartMoreNameCDDefinition();
        } else if ("NormalReportDataDefinition".equals(string)) {
            object = new VanChartNormalReportDataDefinition();
        } else {
            return ChartXMLCompatibleUtils.readDefinition((XMLableReader)xMLableReader);
        }
        xMLableReader.readXMLObject((XMLReadable)object);
        return object;
    }

    private void changeImageLayout(GeneralInfo generalInfo) {
        if (generalInfo == null) {
            return;
        }
        Background background = generalInfo.getBackground();
        if (background instanceof ImageBackground) {
            ((ImageBackground)background).setLayout(2);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        this.vanChartTools.writeXML(xMLPrintWriter);
        if (this.vanChartZoom != null) {
            this.vanChartZoom.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VanChart vanChart = (VanChart)((Object)super.clone());
        vanChart.setVanChartZoom((VanChartZoom)this.getVanChartZoom().clone());
        vanChart.setVanChartTools((VanChartTools)this.getVanChartTools().clone());
        return vanChart;
    }

    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.vanChartZoom != null) {
            this.vanChartZoom.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.vanChartZoom != null) {
            this.vanChartZoom.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.vanChartZoom != null) {
            this.vanChartZoom.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    public boolean equals(Object object) {
        return object instanceof VanChart && super.equals(object) && ComparatorUtils.equals((Object)((VanChart)((Object)object)).getVanChartTools(), (Object)this.getVanChartTools()) && ComparatorUtils.equals((Object)((VanChart)((Object)object)).getVanChartZoom(), (Object)this.getVanChartZoom());
    }

    public boolean accept(Class<? extends Chart> clazz) {
        return ComparatorUtils.equals(VanChart.class, clazz);
    }

    public ChartData defaultChartData() {
        if (this.getPlot() != null) {
            return this.getDataProcessor().getMark() == 1 ? LargeModel.getDefaultChartData(this.getPlot()) : this.getPlot().defaultChartData();
        }
        return null;
    }
}

