/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.scatter;

import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartLegend;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.style.VanChartPlotLegendPane;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import com.fr.plugin.chart.range.LegendType;
import com.fr.plugin.chart.range.component.GradualLegendPane;
import com.fr.plugin.chart.range.component.SectionLegendPane;
import com.fr.plugin.chart.scatter.VanChartScatterLegend;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartScatterPlotLegendPane
extends VanChartPlotLegendPane {
    private static final long serialVersionUID = 1614283200308877353L;
    private JPanel commonLegendPane;
    private JPanel rangeLegendPane;
    private UIButtonGroup<Integer> legendTypeButton;
    private JPanel legendTypeButtonWithTilePane;
    private JPanel ordinaryLegendPane;
    private GradualLegendPane gradualLegendPane;
    private SectionLegendPane sectionLegendPane;

    public VanChartScatterPlotLegendPane() {
    }

    public VanChartScatterPlotLegendPane(VanChartStylePane vanChartStylePane) {
        super(vanChartStylePane);
    }

    private JPanel createRangeLegendPane() {
        this.ordinaryLegendPane = new JPanel();
        this.gradualLegendPane = new GradualLegendPane();
        this.sectionLegendPane = new SectionLegendPane();
        JPanel jPanel = new JPanel(new CardLayout()){

            @Override
            public Dimension getPreferredSize() {
                if (VanChartScatterPlotLegendPane.this.legendTypeButton.getSelectedIndex() == 0) {
                    return new Dimension(VanChartScatterPlotLegendPane.this.ordinaryLegendPane.getWidth(), 0);
                }
                if (VanChartScatterPlotLegendPane.this.legendTypeButton.getSelectedIndex() == 1) {
                    return VanChartScatterPlotLegendPane.this.gradualLegendPane.getPreferredSize();
                }
                return VanChartScatterPlotLegendPane.this.sectionLegendPane.getPreferredSize();
            }
        };
        jPanel.add((Component)this.ordinaryLegendPane, "ordinary");
        jPanel.add((Component)this.gradualLegendPane, "gradual");
        jPanel.add((Component)this.sectionLegendPane, "section");
        return jPanel;
    }

    private JPanel createTableLayoutPaneWithTitle(String string, Component component) {
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(string, component);
    }

    @Override
    protected JPanel createLegendPane() {
        this.legendTypeButton = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Legend_Ordinary"), Inter.getLocText((String)"Plugin-ChartF_Legend_Gradual"), Inter.getLocText((String)"Plugin-ChartF_Legend_Section")});
        this.initLegendTypeButtonListener();
        this.legendTypeButtonWithTilePane = this.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_Legend_Form"), (Component)this.legendTypeButton);
        this.rangeLegendPane = this.createRangeLegendPane();
        this.commonLegendPane = super.createLegendPane();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2};
        double[] dArray2 = new double[]{d, d, d, d};
        Component[][] componentArray = new Component[][]{{this.legendTypeButtonWithTilePane}, {new JSeparator()}, {this.rangeLegendPane}, {this.commonLegendPane}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    private void initLegendTypeButtonListener() {
        this.legendTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartScatterPlotLegendPane.this.checkCardPane();
            }
        });
    }

    private void checkCardPane() {
        CardLayout cardLayout = (CardLayout)this.rangeLegendPane.getLayout();
        if (this.legendTypeButton.getSelectedIndex() == 0) {
            cardLayout.show(this.rangeLegendPane, "ordinary");
        } else if (this.legendTypeButton.getSelectedIndex() == 1) {
            cardLayout.show(this.rangeLegendPane, "gradual");
        } else {
            cardLayout.show(this.rangeLegendPane, "section");
        }
    }

    @Override
    protected void addLegendListener() {
        this.isLegendVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartScatterPlotLegendPane.this.checkBoxUse();
            }
        });
    }

    @Override
    protected void checkAllUse() {
        this.checkBoxUse();
        this.checkDisplayStrategyUse();
        this.checkCardPane();
        this.repaint();
    }

    @Override
    protected void checkBoxUse() {
        this.isLegendVisible.setEnabled(true);
        this.legendPane.setVisible(this.isLegendVisible.isSelected());
    }

    @Override
    public void updateBean(VanChartLegend vanChartLegend) {
        if (vanChartLegend == null) {
            vanChartLegend = new VanChartScatterLegend();
        }
        super.updateBean(vanChartLegend);
        VanChartScatterLegend vanChartScatterLegend = (VanChartScatterLegend)vanChartLegend;
        LegendType legendType = LegendType.ORDINARY;
        switch (this.legendTypeButton.getSelectedIndex()) {
            case 0: {
                legendType = LegendType.ORDINARY;
                break;
            }
            case 1: {
                legendType = LegendType.GRADUAL;
                break;
            }
            case 2: {
                legendType = LegendType.SECTION;
            }
        }
        vanChartScatterLegend.setLegendType(legendType);
        if (legendType == LegendType.GRADUAL) {
            this.gradualLegendPane.update(vanChartScatterLegend.getGradualLegend());
        } else if (legendType == LegendType.SECTION) {
            this.sectionLegendPane.update(vanChartScatterLegend.getSectionLegend());
        }
    }

    @Override
    public void populateBean(VanChartLegend vanChartLegend) {
        VanChartScatterLegend vanChartScatterLegend = (VanChartScatterLegend)vanChartLegend;
        if (vanChartScatterLegend != null) {
            this.isLegendVisible.setSelected(vanChartScatterLegend.isLegendVisible());
            this.textAttrPane.populate(vanChartScatterLegend.getFRFont());
            this.borderPane.populate((GeneralInfo)vanChartScatterLegend);
            this.backgroundPane.populate((GeneralInfo)vanChartScatterLegend);
            if (!vanChartScatterLegend.isFloating()) {
                this.location.setSelectedItem((Object)vanChartScatterLegend.getPosition());
            }
            this.customFloatPositionButton.setSelected(vanChartScatterLegend.isFloating());
            this.customFloatPositionPane.setFloatPosition_x(vanChartScatterLegend.getFloatPercentX());
            this.customFloatPositionPane.setFloatPosition_y(vanChartScatterLegend.getFloatPercentY());
            this.limitSize.setSelectedIndex(vanChartScatterLegend.isLimitSize() ? 0 : 1);
            this.maxProportion.setValue(vanChartScatterLegend.getMaxHeight());
            this.legendTypeButton.setSelectedIndex(vanChartScatterLegend.getLegendType().getIndex());
            this.gradualLegendPane.populate(vanChartScatterLegend.getGradualLegend());
            this.sectionLegendPane.populate(vanChartScatterLegend.getSectionLegend());
        }
        this.checkAllUse();
    }
}

