/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.scatter;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.BubbleChartData;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartLegend;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.base.VanChartAttrMarker;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartDataSeriesWithAlpha;
import com.fr.plugin.chart.line.VanChartLinePlot;
import com.fr.plugin.chart.scatter.VanChartScatterDataPoint;
import com.fr.plugin.chart.scatter.VanChartScatterLegend;
import com.fr.plugin.chart.scatter.VanChartScatterPlotGlyph;
import com.fr.plugin.chart.scatter.attr.ScatterAttrLabel;
import com.fr.plugin.chart.scatter.attr.ScatterAttrTooltip;
import com.fr.plugin.chart.scatter.attr.ScatterAttrTooltipContent;
import com.fr.script.Calculator;
import com.fr.stable.fun.FunctionProcessor;
import java.awt.Color;
import java.util.List;

public class VanChartScatterPlot
extends VanChartLinePlot {
    private static final long serialVersionUID = 6847988748828676249L;
    public static final String VAN_CHART_SCATTER_PLOT_ID = "VanChartScatterPlot";
    private static final String[][] X_VALUE = new String[][]{{"12.5", "37.8", "37.8", "80.3", "56.0", "93.4", "110.0", "115.6", "120", "123.4"}, {"17.5", "33.6", "40.8", "86.3", "50.0", "98.4", "10.0", "113.6", "120.4", "133.0"}};
    private static final String[][] Y_VALUE = new String[][]{{"59.0", "49.2", "63.0", "73.6", "59.0", "147.6", "99.8", "166.8", "100", "198.6"}, {"65.6", "60.8", "80.7", "72.6", "88.8", "174.8", "106.4", "178.4", "92.0", "158.6"}};
    private static final String[][] Z_VALUE = new String[][]{{"60", "70.2", "67.8", "0", "54", "50.8", "87.3", "60.8", "-20", "30.2"}, {"70", "80.2", "77.8", "62.8", "64", "0", "97.3", "70.8", "33.0", "40.2"}};
    private static final String[] X_ITEM = new String[]{"Female", "Male"};

    @Override
    protected VanChartLegend initLegend() {
        return new VanChartScatterLegend();
    }

    @Override
    protected void initXYAxisList() {
        this.xAxisList = VanChartAttrHelper.createScatterXAxisList();
        this.yAxisList = VanChartAttrHelper.createDefaultYAxisList();
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        VanChartScatterPlotGlyph vanChartScatterPlotGlyph = new VanChartScatterPlotGlyph();
        this.install4PlotGlyph(vanChartScatterPlotGlyph, chartData);
        this.installAxisGlyph(vanChartScatterPlotGlyph, chartData);
        return vanChartScatterPlotGlyph;
    }

    @Override
    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        BubbleChartData bubbleChartData = ChartXMLUtils.chartData4Bubble((ChartData)chartData);
        this.addSeriesByIndex(0, bubbleChartData.getItemCount(), plotGlyph, (ChartData)bubbleChartData);
        this.dealDataSeriesAndPointOtherAttr(plotGlyph);
    }

    @Override
    protected void dealDataPointOtherAttr(VanChartDataPoint vanChartDataPoint, boolean bl, ConditionCollection conditionCollection, Color color, VanChartDataSeries vanChartDataSeries) {
        if (bl) {
            this.dealDataPointCustomCondition(vanChartDataPoint, conditionCollection, vanChartDataSeries);
            vanChartDataPoint.setDefaultColor(color);
        }
    }

    protected void dealDataPointCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection, VanChartDataSeries vanChartDataSeries) {
        this.dealDataPointAttrLabelCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrTooltipCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrMarkerCustomCondition(vanChartDataPoint, conditionCollection, vanChartDataSeries);
        this.dealDataPointAttrBackgroundCustomCondition(vanChartDataPoint, conditionCollection, vanChartDataSeries);
        this.dealDataPointAttrAlphaCustomCondition(vanChartDataPoint, conditionCollection);
    }

    protected void dealDataPointAttrMarkerCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection, VanChartDataSeries vanChartDataSeries) {
        VanChartAttrMarker vanChartAttrMarker = (VanChartAttrMarker)conditionCollection.getCustomDataSeriesCondition(VanChartAttrMarker.class, (Result)vanChartDataPoint);
        VanChartAttrMarker vanChartAttrMarker2 = vanChartDataSeries.getMarker();
        if (vanChartAttrMarker != null && !ComparatorUtils.equals((Object)((Object)vanChartAttrMarker), (Object)((Object)vanChartAttrMarker2))) {
            ((VanChartScatterDataPoint)vanChartDataPoint).setAttrMarker(vanChartAttrMarker);
        }
    }

    protected void dealDataPointAttrBackgroundCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection, VanChartDataSeries vanChartDataSeries) {
        AttrBackground attrBackground = (AttrBackground)conditionCollection.getCustomDataSeriesCondition(AttrBackground.class, (Result)vanChartDataPoint);
        AttrBackground attrBackground2 = vanChartDataSeries.getColor();
        if (attrBackground != null && !ComparatorUtils.equals((Object)attrBackground, (Object)attrBackground2)) {
            vanChartDataPoint.setColor(attrBackground);
        }
    }

    @Override
    protected void dealDataPointAttrLabelCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        ScatterAttrLabel scatterAttrLabel = (ScatterAttrLabel)conditionCollection.getCustomDataSeriesCondition(ScatterAttrLabel.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setLabel(scatterAttrLabel);
    }

    @Override
    protected void dealDataPointAttrTooltipCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        ScatterAttrTooltip scatterAttrTooltip = (ScatterAttrTooltip)conditionCollection.getCustomDataSeriesCondition(ScatterAttrTooltip.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setTooltip(scatterAttrTooltip);
    }

    @Override
    protected void dealDataSeriesCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        this.dealDataSeriesAttrBackgroundCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrTrendLineCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrMarkerCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrLineCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrAlphaCustomCondition(vanChartDataSeries, conditionCollection);
    }

    @Override
    protected void addSeriesByIndex(int n, int n2, PlotGlyph plotGlyph, ChartData chartData) {
        int n3;
        BubbleChartData bubbleChartData = (BubbleChartData)chartData;
        int n4 = n3 = bubbleChartData == null ? 0 : bubbleChartData.getItemCount();
        for (int i = n; i < n2 && i < n3; ++i) {
            DataSeries dataSeries = this.createDataSeries(i - n);
            dataSeries.setSeriesName(Utils.objectToString((Object)bubbleChartData.getItems()[i]));
            plotGlyph.addSeries(dataSeries);
            for (int j = 0; j < bubbleChartData.getCategoryLabelCount(); ++j) {
                VanChartScatterDataPoint vanChartScatterDataPoint = (VanChartScatterDataPoint)this.createDataPoint();
                vanChartScatterDataPoint.setCategoryIndex(j);
                vanChartScatterDataPoint.setSeriesIndex(i - n);
                double d = 0.0;
                if (i < bubbleChartData.getItemCount() && j < bubbleChartData.getCategoryLabelCount()) {
                    Number number = bubbleChartData.getY(i, j);
                    if (number != null) {
                        d = number.doubleValue();
                    } else {
                        vanChartScatterDataPoint.setValueIsNull(true);
                        d = 0.0;
                    }
                    vanChartScatterDataPoint.setValue(d);
                    number = bubbleChartData.getSize(i, j);
                    if (number != null) {
                        d = number.doubleValue();
                    } else {
                        vanChartScatterDataPoint.setSizeIsNull(true);
                        d = 0.0;
                    }
                    vanChartScatterDataPoint.setSizeValue(d);
                }
                if (j < bubbleChartData.getCategoryLabelCount()) {
                    vanChartScatterDataPoint.setCategoryName(Utils.objectToString((Object)bubbleChartData.getX(i, j)));
                    vanChartScatterDataPoint.setCategoryOriginalName(Utils.objectToString((Object)bubbleChartData.getX(i, j)));
                }
                if (i < bubbleChartData.getItemCount()) {
                    vanChartScatterDataPoint.setSeriesName(Utils.objectToString((Object)bubbleChartData.getItems()[i]));
                    vanChartScatterDataPoint.setSeriesOriginalName(Utils.objectToString((Object)bubbleChartData.getItems()[i]));
                }
                dataSeries.addDataPoint((DataPoint)vanChartScatterDataPoint);
            }
        }
    }

    @Override
    public boolean isSupportDataSheet() {
        return false;
    }

    @Override
    protected DataPoint createDataPoint() {
        return new VanChartScatterDataPoint();
    }

    @Override
    protected DataSeries createDataSeries(int n) {
        return new VanChartDataSeriesWithAlpha(n);
    }

    @Override
    public String getPlotID() {
        return VAN_CHART_SCATTER_PLOT_ID;
    }

    @Override
    public AttrTooltip getDefaultAttrTooltip() {
        ScatterAttrTooltip scatterAttrTooltip = new ScatterAttrTooltip();
        ScatterAttrTooltipContent scatterAttrTooltipContent = (ScatterAttrTooltipContent)scatterAttrTooltip.getContent();
        scatterAttrTooltipContent.getXFormat().setEnable(true);
        scatterAttrTooltipContent.getYFormat().setEnable(true);
        scatterAttrTooltipContent.getSizeFormat().setEnable(true);
        scatterAttrTooltipContent.getSeriesFormat().setEnable(true);
        return scatterAttrTooltip;
    }

    @Override
    public AttrLabel getDefaultAttrLabel() {
        ScatterAttrLabel scatterAttrLabel = new ScatterAttrLabel();
        ScatterAttrTooltipContent scatterAttrTooltipContent = (ScatterAttrTooltipContent)scatterAttrLabel.getAttrLabelDetail().getContent();
        scatterAttrTooltipContent.getXFormat().setEnable(true);
        scatterAttrTooltipContent.getYFormat().setEnable(true);
        scatterAttrTooltipContent.getSizeFormat().setEnable(true);
        scatterAttrTooltipContent.getSeriesFormat().setEnable(false);
        return scatterAttrLabel;
    }

    @Override
    public ChartData defaultChartData() {
        return new BubbleChartData((Object[])X_ITEM, (Object[][])X_VALUE, (Object[][])Y_VALUE, (Object[][])Z_VALUE);
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.XY_SCATTER_VAN_CHART;
    }

    @Override
    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(VanChartScatterPlot.class, clazz);
    }

    @Override
    public String getPlotName() {
        return Inter.getLocText((String)"Plugin-ChartF_NewScatter");
    }

    @Override
    public boolean isSupportTooltipSeriesType() {
        return false;
    }

    @Override
    public DataSeriesCondition getAttrLabelFromConditionCollection() {
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        DataSeriesCondition dataSeriesCondition = conditionAttr.getExisted(ScatterAttrLabel.class);
        return dataSeriesCondition;
    }

    @Override
    public DataSeriesCondition getAttrTooltipFromConditionCollection() {
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        DataSeriesCondition dataSeriesCondition = conditionAttr.getExisted(ScatterAttrTooltip.class);
        return dataSeriesCondition;
    }

    @Override
    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.getLegend() != null && this.getLegend() instanceof VanChartScatterLegend) {
            ((VanChartScatterLegend)this.getLegend()).dealFormula(calculator);
        }
    }

    @Override
    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.dealFormula(calculator);
        if (this.getLegend() != null && this.getLegend() instanceof VanChartScatterLegend) {
            ((VanChartScatterLegend)this.getLegend()).buidExecuteSequenceList(list, calculator);
        }
    }

    @Override
    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.getLegend() != null && this.getLegend() instanceof VanChartScatterLegend) {
            ((VanChartScatterLegend)this.getLegend()).modFormulaString(mOD_COLUMN_ROW);
        }
    }
}

