/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge;

import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.gui.ChartStylePane;
import com.fr.design.mainframe.chart.gui.style.series.ColorPickerPaneWithFormula;
import com.fr.design.mainframe.chart.gui.style.series.UIColorPickerPane;
import com.fr.design.style.color.ColorSelectBox;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.style.series.VanChartAbstractPlotSeriesPane;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.GaugeStyle;
import com.fr.plugin.chart.gauge.VanChartGaugePlot;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VanChartGaugeSeriesPane
extends VanChartAbstractPlotSeriesPane {
    private static final long serialVersionUID = -4414343926082129759L;
    private UIButtonGroup gaugeLayout;
    private ColorSelectBox hingeColor;
    private ColorSelectBox hingeBackgroundColor;
    private ColorSelectBox needleColor;
    private ColorSelectBox paneBackgroundColor;
    private ColorSelectBox slotBackgroundColor;
    private UIButtonGroup rotate;
    private ColorSelectBox innerPaneBackgroundColor;
    private UIColorPickerPane colorPickerPane;

    public VanChartGaugeSeriesPane(ChartStylePane chartStylePane, Plot plot) {
        super(chartStylePane, plot);
    }

    protected JPanel getContentInPlotType() {
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2};
        double[] dArray2 = new double[]{d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{this.createGaugeLayoutPane()}, {new JSeparator()}, {this.createGaugeStylePane(dArray2, new double[]{d, d2})}, {new JSeparator()}, {this.createGaugeBandsPane()}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    private JPanel createGaugeLayoutPane() {
        this.gaugeLayout = new UIButtonGroup(new String[]{Inter.getLocText((String)"FR-Chart-Direction_Horizontal"), Inter.getLocText((String)"FR-Chart-Direction_Vertical")});
        this.gaugeLayout.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                VanChartGaugeSeriesPane.this.changeLabelPosition();
            }
        });
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Chart_Layout"), (Component)this.gaugeLayout);
    }

    private void changeLabelPosition() {
        VanChartGaugePlot vanChartGaugePlot;
        if (this.plot instanceof VanChartGaugePlot && ComparatorUtils.equals((Object)((Object)(vanChartGaugePlot = (VanChartGaugePlot)this.plot).getGaugeStyle()), (Object)((Object)GaugeStyle.THERMOMETER))) {
            ConditionAttr conditionAttr = vanChartGaugePlot.getConditionCollection().getDefaultAttr();
            AttrLabel attrLabel = (AttrLabel)conditionAttr.getExisted(AttrLabel.class);
            if (attrLabel == null) {
                return;
            }
            if (this.gaugeLayout.getSelectedIndex() == 0) {
                attrLabel.getAttrLabelDetail().setPosition(2);
                attrLabel.getAttrLabelDetail().getTextAttr().setFRFont(VanChartGaugePlot.THERMOMETER_VERTICAL_PERCENT_LABEL_FONT);
                attrLabel.getGaugeValueLabelDetail().setPosition(2);
            } else {
                attrLabel.getAttrLabelDetail().setPosition(3);
                attrLabel.getAttrLabelDetail().getTextAttr().setFRFont(VanChartGaugePlot.THERMOMETER_PERCENT_LABEL_FONT);
                attrLabel.getGaugeValueLabelDetail().setPosition(3);
            }
        }
    }

    private JPanel createGaugeStylePane(double[] dArray, double[] dArray2) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 6));
        JPanel jPanel2 = TableLayoutHelper.createTableLayoutPane((Component[][])this.getDiffComponentsWithGaugeStyle(), (double[])dArray, (double[])dArray2);
        jPanel.add((Component)jPanel2, "Center");
        if (this.rotate != null) {
            jPanel.add((Component)this.rotate, "North");
        }
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Designer-Widget_Style"), jPanel);
    }

    private Component[][] getDiffComponentsWithGaugeStyle() {
        GaugeStyle gaugeStyle = this.plot == null ? GaugeStyle.POINTER : ((VanChartGaugePlot)this.plot).getGaugeStyle();
        switch (gaugeStyle) {
            case RING: {
                this.initRotate();
                return new Component[][]{this.getPaneBackgroundColor(), this.getInnerPaneBackgroundColor()};
            }
            case SLOT: {
                return new Component[][]{this.getNeedleColor(), this.getSlotBackgroundColor()};
            }
            case THERMOMETER: {
                return new Component[][]{this.getNeedleColor(), this.getSlotBackgroundColor()};
            }
        }
        return new Component[][]{this.getHingeColor(), this.getHingeBackgroundColor(), this.getNeedleColor(), this.getPaneBackgroundColor()};
    }

    private Component[] getHingeColor() {
        this.hingeColor = new ColorSelectBox(120);
        return new Component[]{new UILabel(Inter.getLocText((String)"Plugin-ChartF_Hinge")), this.hingeColor};
    }

    private Component[] getHingeBackgroundColor() {
        this.hingeBackgroundColor = new ColorSelectBox(120);
        return new Component[]{new UILabel(Inter.getLocText((String)"Plugin-ChartF_HingeBackground")), this.hingeBackgroundColor};
    }

    private Component[] getNeedleColor() {
        this.needleColor = new ColorSelectBox(120);
        return new Component[]{new UILabel(Inter.getLocText((String)"Plugin-ChartF_Needle")), this.needleColor};
    }

    private Component[] getPaneBackgroundColor() {
        this.paneBackgroundColor = new ColorSelectBox(120);
        return new Component[]{new UILabel(Inter.getLocText((String)"Plugin-ChartF_PaneBackground")), this.paneBackgroundColor};
    }

    private Component[] getSlotBackgroundColor() {
        this.slotBackgroundColor = new ColorSelectBox(120);
        return new Component[]{new UILabel(Inter.getLocText((String)"Plugin-ChartF_SlotBackground")), this.slotBackgroundColor};
    }

    private void initRotate() {
        this.rotate = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_AntiClockWise"), Inter.getLocText((String)"Plugin-ChartF_ClockWise")});
    }

    private Component[] getInnerPaneBackgroundColor() {
        this.innerPaneBackgroundColor = new ColorSelectBox(120);
        return new Component[]{new UILabel(Inter.getLocText((String)"Plugin-ChartF_InnerPaneBackground")), this.innerPaneBackgroundColor};
    }

    private JPanel createGaugeBandsPane() {
        this.colorPickerPane = new ColorPickerPaneWithFormula("meterString");
        return TableLayout4VanChartHelper.createTitlePane(Inter.getLocText((String)"Plugin-ChartF_Range"), (Component)this.colorPickerPane, 16);
    }

    @Override
    public void populateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.populateBean(plot);
        if (plot instanceof VanChartGaugePlot) {
            VanChartGaugePlot vanChartGaugePlot = (VanChartGaugePlot)plot;
            GaugeDetailStyle gaugeDetailStyle = vanChartGaugePlot.getGaugeDetailStyle();
            this.gaugeLayout.setSelectedIndex(gaugeDetailStyle.isHorizontalLayout() ? 0 : 1);
            if (this.hingeColor != null) {
                this.hingeColor.setSelectObject(gaugeDetailStyle.getHingeColor());
            }
            if (this.hingeBackgroundColor != null) {
                this.hingeBackgroundColor.setSelectObject(gaugeDetailStyle.getHingeBackgroundColor());
            }
            if (this.needleColor != null) {
                this.needleColor.setSelectObject(gaugeDetailStyle.getNeedleColor());
            }
            if (this.paneBackgroundColor != null) {
                this.paneBackgroundColor.setSelectObject(gaugeDetailStyle.getPaneBackgroundColor());
            }
            if (this.slotBackgroundColor != null) {
                this.slotBackgroundColor.setSelectObject(gaugeDetailStyle.getSlotBackgroundColor());
            }
            if (this.rotate != null) {
                this.rotate.setSelectedIndex(gaugeDetailStyle.isAntiClockWise() ? 0 : 1);
            }
            if (this.innerPaneBackgroundColor != null) {
                this.innerPaneBackgroundColor.setSelectObject(gaugeDetailStyle.getInnerPaneBackgroundColor());
            }
            this.colorPickerPane.populateBean(gaugeDetailStyle.getHotAreaColor());
        }
    }

    @Override
    public void updateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.updateBean(plot);
        if (plot instanceof VanChartGaugePlot) {
            VanChartGaugePlot vanChartGaugePlot = (VanChartGaugePlot)plot;
            GaugeDetailStyle gaugeDetailStyle = vanChartGaugePlot.getGaugeDetailStyle();
            gaugeDetailStyle.setHorizontalLayout(this.gaugeLayout.getSelectedIndex() == 0);
            if (this.hingeColor != null) {
                gaugeDetailStyle.setHingeColor(this.hingeColor.getSelectObject());
            }
            if (this.hingeBackgroundColor != null) {
                gaugeDetailStyle.setHingeBackgroundColor(this.hingeBackgroundColor.getSelectObject());
            }
            if (this.needleColor != null) {
                gaugeDetailStyle.setNeedleColor(this.needleColor.getSelectObject());
            }
            if (this.paneBackgroundColor != null) {
                gaugeDetailStyle.setPaneBackgroundColor(this.paneBackgroundColor.getSelectObject());
            }
            if (this.slotBackgroundColor != null) {
                gaugeDetailStyle.setSlotBackgroundColor(this.slotBackgroundColor.getSelectObject());
            }
            if (this.rotate != null) {
                gaugeDetailStyle.setAntiClockWise(this.rotate.getSelectedIndex() == 0);
            }
            if (this.innerPaneBackgroundColor != null) {
                gaugeDetailStyle.setInnerPaneBackgroundColor(this.innerPaneBackgroundColor.getSelectObject());
            }
            this.colorPickerPane.updateBean(gaugeDetailStyle.getHotAreaColor());
        }
    }
}

