/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.label;

import com.fr.chart.chartattr.Plot;
import com.fr.design.beans.BasicBeanPane;
import com.fr.design.dialog.BasicPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.gui.style.ChartTextAttrPane;
import com.fr.design.style.color.ColorSelectBox;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.plot.VanChartLabelPositionPlot;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.base.AttrTooltipContent;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.VanChartLabelContentPane;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VanChartPlotLabelDetailPane
extends BasicPane {
    private static final long serialVersionUID = -22438250307946275L;
    protected BasicBeanPane<AttrTooltipContent> dataLabelContentPane;
    protected UIButtonGroup<Integer> position;
    protected UIToggleButton tractionLine;
    protected UIButtonGroup<Integer> style;
    protected ChartTextAttrPane textFontPane;
    protected ColorSelectBox backgroundColor;
    protected VanChartStylePane parent;

    public VanChartPlotLabelDetailPane(Plot plot, VanChartStylePane vanChartStylePane) {
        this.parent = vanChartStylePane;
        this.setLayout(new BorderLayout());
        this.initToolTipContentPane(plot);
        JPanel jPanel = this.createLabelPane(plot);
        this.add(jPanel, "Center");
    }

    protected void initToolTipContentPane(Plot plot) {
        this.dataLabelContentPane = new VanChartLabelContentPane(this.parent, (JPanel)((Object)this));
    }

    private JPanel createLabelPane(Plot plot) {
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = this.getLabelPaneRowSize(plot, d);
        Component[][] componentArray = this.getLabelPaneComponents(plot, d, dArray);
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    protected Component[][] getLabelPaneComponents(Plot plot, double d, double[] dArray) {
        if (this.hasLabelPosition(plot)) {
            return new Component[][]{{this.dataLabelContentPane, null}, {new JSeparator(), null}, {this.createLabelPositionPane(new double[]{d, d}, dArray, plot), null}, {new JSeparator(), null}, {this.createLabelStylePane(new double[]{d, d}, dArray, plot), null}};
        }
        return new Component[][]{{this.dataLabelContentPane, null}, {new JSeparator(), null}, {this.createLabelStylePane(new double[]{d, d}, dArray, plot), null}};
    }

    protected double[] getLabelPaneRowSize(Plot plot, double d) {
        double[] dArray;
        if (this.hasLabelPosition(plot)) {
            double[] dArray2 = new double[5];
            dArray2[0] = d;
            dArray2[1] = d;
            dArray2[2] = d;
            dArray2[3] = d;
            dArray = dArray2;
            dArray2[4] = d;
        } else {
            double[] dArray3 = new double[3];
            dArray3[0] = d;
            dArray3[1] = d;
            dArray = dArray3;
            dArray3[2] = d;
        }
        return dArray;
    }

    protected boolean hasLabelPosition(Plot plot) {
        return plot instanceof VanChartLabelPositionPlot;
    }

    protected JPanel createTableLayoutPaneWithTitle(String string, Component component) {
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(string, component);
    }

    protected JPanel createLabelPositionPane(double[] dArray, double[] dArray2, Plot plot) {
        if (plot instanceof VanChartLabelPositionPlot) {
            this.position = new UIButtonGroup(((VanChartLabelPositionPlot)plot).getLabelLocationNameArray(), (Object[])((VanChartLabelPositionPlot)plot).getLabelLocationValueArray());
            if (plot.isSupportLeadLine()) {
                this.tractionLine = new UIToggleButton(Inter.getLocText((String)"ChartF-Show_GuidLine"));
                Component[][] componentArray = new Component[][]{{this.position, null}, {this.tractionLine, null}};
                this.initPositionListener();
                JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
                return this.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Chart-Layout_Position"), jPanel);
            }
            return this.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Chart-Layout_Position"), (Component)this.position);
        }
        return new JPanel();
    }

    protected void initPositionListener() {
        this.position.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                VanChartPlotLabelDetailPane.this.checkPosition();
            }
        });
    }

    protected JPanel createLabelStylePane(double[] dArray, double[] dArray2, Plot plot) {
        this.style = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Automatic"), Inter.getLocText((String)"Plugin-ChartF_Custom")});
        this.textFontPane = new ChartTextAttrPane();
        this.initStyleListener();
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])this.getLabelStyleComponents(plot), (double[])dArray, (double[])dArray2);
        return this.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Designer-Widget_Style"), jPanel);
    }

    protected Component[][] getLabelStyleComponents(Plot plot) {
        return new Component[][]{{this.style, null}, {this.textFontPane, null}};
    }

    private void initStyleListener() {
        this.style.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartPlotLabelDetailPane.this.checkStyleUse();
            }
        });
    }

    protected JPanel createBackgroundColorPane() {
        this.backgroundColor = new ColorSelectBox(100);
        return this.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_Background"), (Component)this.backgroundColor);
    }

    protected String title4PopupWindow() {
        return null;
    }

    private void checkAllUse() {
        this.checkStyleUse();
        if (this.tractionLine == null) {
            return;
        }
        this.checkPositionEnabled();
    }

    private void checkStyleUse() {
        this.textFontPane.setEnabled(this.style.getSelectedIndex() == 1);
    }

    private void checkPosition() {
        this.tractionLine.setSelected((Integer)this.position.getSelectedItem() == 6);
        this.checkPositionEnabled();
    }

    private void checkPositionEnabled() {
        this.tractionLine.setEnabled((Integer)this.position.getSelectedItem() == 6);
    }

    public void populate(AttrLabelDetail attrLabelDetail) {
        this.dataLabelContentPane.populateBean((Object)attrLabelDetail.getContent());
        if (this.position != null) {
            this.position.setSelectedItem((Object)attrLabelDetail.getPosition());
        }
        if (this.tractionLine != null) {
            this.tractionLine.setSelected(attrLabelDetail.isShowGuidLine());
        }
        this.style.setSelectedIndex(attrLabelDetail.isCustom() ? 1 : 0);
        this.textFontPane.populate(attrLabelDetail.getTextAttr());
        if (this.backgroundColor != null) {
            this.backgroundColor.setSelectObject(attrLabelDetail.getBackgroundColor());
        }
        this.checkAllUse();
    }

    public void update(AttrLabelDetail attrLabelDetail) {
        attrLabelDetail.setContent((AttrTooltipContent)this.dataLabelContentPane.updateBean());
        if (this.position != null && this.position.getSelectedItem() != null) {
            attrLabelDetail.setPosition((Integer)this.position.getSelectedItem());
        } else if (this.position != null) {
            this.position.setSelectedItem((Object)attrLabelDetail.getPosition());
        }
        if (this.tractionLine != null) {
            attrLabelDetail.setShowGuidLine(this.tractionLine.isSelected() && attrLabelDetail.getPosition() == 6);
        }
        attrLabelDetail.setCustom(this.style.getSelectedIndex() == 1);
        if (this.textFontPane != null) {
            attrLabelDetail.setTextAttr(this.textFontPane.update());
        }
        if (this.backgroundColor != null) {
            attrLabelDetail.setBackgroundColor(this.backgroundColor.getSelectObject());
        }
    }
}

