/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.axis;

import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.design.beans.BasicBeanPane;
import com.fr.design.dialog.BasicScrollPane;
import com.fr.design.mainframe.chart.PaneTitleConstants;
import com.fr.general.ComparatorUtils;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.plot.VanChartAxisPlot;
import com.fr.plugin.chart.attr.plot.VanChartRectanglePlot;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.column.VanChartColumnPlot;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import com.fr.plugin.chart.designer.style.axis.AxisPaneFactory;
import com.fr.plugin.chart.designer.style.axis.VanChartAxisScrollPaneWithOutTypeSelect;
import com.fr.plugin.chart.designer.style.axis.VanChartAxisScrollPaneWithTypeSelect;
import com.fr.plugin.chart.designer.style.axis.VanChartXYAxisPaneInterface;
import com.fr.plugin.chart.designer.style.axis.component.VanChartAxisButtonPane;
import com.fr.plugin.chart.designer.style.axis.gauge.VanChartAxisScrollPaneWithGauge;
import com.fr.plugin.chart.gauge.VanChartGaugePlot;
import com.fr.plugin.chart.vanchart.VanChart;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class VanChartAxisPane
extends BasicBeanPane<VanChart> {
    private static final long serialVersionUID = 3208082344409802817L;
    protected VanChartAxisButtonPane axisButtonPane;
    protected JPanel centerPane;
    private CardLayout cardLayout;
    protected List<VanChartXYAxisPaneInterface> xAxisPaneList;
    protected List<VanChartXYAxisPaneInterface> yAxisPaneList;
    protected VanChartAxisPlot editingPlot;
    protected VanChartStylePane parent;

    public VanChartAxisPane(VanChartStylePane vanChartStylePane) {
        this.parent = vanChartStylePane;
        this.initComponents();
    }

    protected void initComponents() {
        this.xAxisPaneList = new ArrayList<VanChartXYAxisPaneInterface>();
        this.yAxisPaneList = new ArrayList<VanChartXYAxisPaneInterface>();
        this.setLayout(new BorderLayout());
        this.axisButtonPane = new VanChartAxisButtonPane(this);
        this.cardLayout = new CardLayout();
        this.centerPane = new JPanel(this.cardLayout);
        this.add((Component)((Object)this.axisButtonPane), "North");
        this.add(this.centerPane, "Center");
    }

    public void changeAxisSelected(String string) {
        this.cardLayout.show(this.centerPane, string);
    }

    public void addXAxis(String string) {
        List<VanChartAxis> list = this.editingPlot.getXAxisList();
        list.add(this.editingPlot.createXAxis(string, 3));
        this.populate();
    }

    public void addYAxis(String string) {
        List<VanChartAxis> list = this.editingPlot.getYAxisList();
        list.add(this.editingPlot.createYAxis(string, 2));
        this.populate();
    }

    public void removeAxis(String string) {
        VanChartAxis vanChartAxis;
        int n;
        List<VanChartAxis> list = this.editingPlot.getXAxisList();
        List<VanChartAxis> list2 = this.editingPlot.getYAxisList();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            vanChartAxis = list.get(n);
            if (!ComparatorUtils.equals((Object)string, (Object)vanChartAxis.getAxisName())) continue;
            list.remove((Object)vanChartAxis);
            this.populate();
            this.removeOthers(n, true);
            return;
        }
        n2 = list2.size();
        for (n = 0; n < n2; ++n) {
            vanChartAxis = list2.get(n);
            if (!ComparatorUtils.equals((Object)string, (Object)vanChartAxis.getAxisName())) continue;
            list2.remove((Object)vanChartAxis);
            this.removeOthers(n, false);
            this.populate();
            return;
        }
    }

    private void removeOthers(int n, boolean bl) {
        ConditionCollection conditionCollection = this.editingPlot.getStackAndAxisCondition();
        if (conditionCollection == null) {
            return;
        }
        int n2 = conditionCollection.getConditionAttrSize();
        for (int i = 0; i < n2; ++i) {
            int n3;
            ConditionAttr conditionAttr = conditionCollection.getConditionAttr(i);
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = (AttrSeriesStackAndAxis)conditionAttr.getExisted(AttrSeriesStackAndAxis.class);
            int n4 = n3 = bl ? attrSeriesStackAndAxis.getXAxisIndex() : attrSeriesStackAndAxis.getYAxisIndex();
            if (n3 != n) continue;
            conditionCollection.removeConditionAttr(conditionAttr);
        }
    }

    protected String title4PopupWindow() {
        return PaneTitleConstants.CHART_STYLE_AXIS_TITLE;
    }

    public void populateBean(VanChart vanChart) {
        if (vanChart == null) {
            return;
        }
        Plot plot = vanChart.getPlot();
        if (plot.isMeterPlot()) {
            this.populateGaugePlotAxisPane((VanChartGaugePlot)plot);
        } else {
            this.editingPlot = (VanChartAxisPlot)plot;
            this.populate();
        }
    }

    private void populateGaugePlotAxisPane(VanChartGaugePlot vanChartGaugePlot) {
        VanChartAxisScrollPaneWithGauge vanChartAxisScrollPaneWithGauge = new VanChartAxisScrollPaneWithGauge();
        vanChartAxisScrollPaneWithGauge.setGaugeStyle(vanChartGaugePlot.getGaugeStyle());
        vanChartAxisScrollPaneWithGauge.populateBean(vanChartGaugePlot.getGaugeAxis());
        this.yAxisPaneList.add(vanChartAxisScrollPaneWithGauge);
        this.removeAll();
        this.add((Component)((Object)vanChartAxisScrollPaneWithGauge), "Center");
        this.parent.initAllListeners();
    }

    protected void populate() {
        if (this.editingPlot == null) {
            return;
        }
        this.xAxisPaneList.clear();
        this.yAxisPaneList.clear();
        this.centerPane.removeAll();
        List<VanChartAxis> list = this.editingPlot.getXAxisList();
        List<VanChartAxis> list2 = this.editingPlot.getYAxisList();
        if (this.editingPlot instanceof VanChartColumnPlot && ((VanChartColumnPlot)this.editingPlot).isBar()) {
            this.populateBarAxisList(list, list2);
        } else {
            this.populateAxisList(list, list2);
        }
        this.axisButtonPane.populateBean(this.editingPlot);
        this.parent.initAllListeners();
    }

    private void populateAxisList(List<VanChartAxis> list, List<VanChartAxis> list2) {
        VanChartXYAxisPaneInterface vanChartXYAxisPaneInterface;
        for (VanChartAxis vanChartAxis : list) {
            vanChartXYAxisPaneInterface = AxisPaneFactory.getXAxisScrollPane(this.editingPlot);
            if (vanChartXYAxisPaneInterface == null) {
                vanChartXYAxisPaneInterface = new VanChartAxisScrollPaneWithTypeSelect();
            }
            vanChartXYAxisPaneInterface.populate(vanChartAxis, null);
            this.centerPane.add((Component)((JPanel)((Object)vanChartXYAxisPaneInterface)), vanChartAxis.getAxisName());
            this.xAxisPaneList.add(vanChartXYAxisPaneInterface);
        }
        for (VanChartAxis vanChartAxis : list2) {
            vanChartXYAxisPaneInterface = AxisPaneFactory.getYAxisScrollPane(this.editingPlot);
            if (vanChartXYAxisPaneInterface == null) {
                vanChartXYAxisPaneInterface = new VanChartAxisScrollPaneWithOutTypeSelect();
            }
            vanChartXYAxisPaneInterface.populate(vanChartAxis, null);
            this.centerPane.add((Component)((JPanel)((Object)vanChartXYAxisPaneInterface)), vanChartAxis.getAxisName());
            this.yAxisPaneList.add(vanChartXYAxisPaneInterface);
        }
    }

    private void populateBarAxisList(List<VanChartAxis> list, List<VanChartAxis> list2) {
        BasicScrollPane basicScrollPane;
        for (VanChartAxis vanChartAxis : list) {
            basicScrollPane = new VanChartAxisScrollPaneWithOutTypeSelect();
            basicScrollPane.populate(vanChartAxis, this.parent);
            this.centerPane.add((Component)basicScrollPane, vanChartAxis.getAxisName());
            this.xAxisPaneList.add((VanChartXYAxisPaneInterface)basicScrollPane);
        }
        for (VanChartAxis vanChartAxis : list2) {
            basicScrollPane = new VanChartAxisScrollPaneWithTypeSelect();
            basicScrollPane.populate(vanChartAxis, this.parent);
            this.centerPane.add((Component)basicScrollPane, vanChartAxis.getAxisName());
            this.yAxisPaneList.add((VanChartXYAxisPaneInterface)basicScrollPane);
        }
    }

    public void updateBean(VanChart vanChart) {
        if (vanChart == null) {
            return;
        }
        Plot plot = vanChart.getPlot();
        if (plot.isMeterPlot()) {
            this.updateGaugePlotAxisPane((VanChartGaugePlot)plot);
        } else {
            this.update((VanChartRectanglePlot)plot);
        }
    }

    private void updateGaugePlotAxisPane(VanChartGaugePlot vanChartGaugePlot) {
        if (this.yAxisPaneList.isEmpty()) {
            return;
        }
        this.yAxisPaneList.get(0).update(vanChartGaugePlot.getGaugeAxis());
    }

    private void update(VanChartRectanglePlot vanChartRectanglePlot) {
        int n;
        if (vanChartRectanglePlot == null) {
            return;
        }
        List<VanChartAxis> list = vanChartRectanglePlot.getXAxisList();
        List<VanChartAxis> list2 = vanChartRectanglePlot.getYAxisList();
        ArrayList<VanChartAxis> arrayList = new ArrayList<VanChartAxis>();
        ArrayList<VanChartAxis> arrayList2 = new ArrayList<VanChartAxis>();
        int n2 = this.xAxisPaneList.size();
        for (n = 0; n < n2; ++n) {
            arrayList.add(this.xAxisPaneList.get(n).update(list.get(n)));
        }
        n2 = this.yAxisPaneList.size();
        for (n = 0; n < n2; ++n) {
            arrayList2.add(this.yAxisPaneList.get(n).update(list2.get(n)));
        }
        vanChartRectanglePlot.setXAxisList(arrayList);
        vanChartRectanglePlot.setYAxisList(arrayList2);
    }

    public VanChart updateBean() {
        return null;
    }
}

