/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.axis;

import com.fr.base.FRContext;
import com.fr.plugin.chart.area.VanChartAreaPlot;
import com.fr.plugin.chart.attr.plot.VanChartAxisPlot;
import com.fr.plugin.chart.column.VanChartColumnPlot;
import com.fr.plugin.chart.designer.style.axis.VanChartAxisScrollPaneWithOutTypeSelect;
import com.fr.plugin.chart.designer.style.axis.VanChartAxisScrollPaneWithTypeSelect;
import com.fr.plugin.chart.designer.style.axis.VanChartXYAxisPaneInterface;
import com.fr.plugin.chart.designer.style.axis.gauge.VanChartAxisScrollPaneWithGauge;
import com.fr.plugin.chart.designer.style.axis.radar.VanChartXAxisScrollPaneWithRadar;
import com.fr.plugin.chart.designer.style.axis.radar.VanChartYAxisScrollPaneWithRadar;
import com.fr.plugin.chart.gauge.VanChartGaugePlot;
import com.fr.plugin.chart.line.VanChartLinePlot;
import com.fr.plugin.chart.radar.VanChartRadarPlot;
import java.util.HashMap;

public class AxisPaneFactory {
    private static HashMap<String, Class<? extends VanChartXYAxisPaneInterface>> XAxisPaneMap = new HashMap();
    private static HashMap<String, Class<? extends VanChartXYAxisPaneInterface>> YAxisPaneMap = new HashMap();

    private static void initXAxisPaneMap() {
        XAxisPaneMap.put(VanChartColumnPlot.class.getName(), VanChartAxisScrollPaneWithTypeSelect.class);
        XAxisPaneMap.put(VanChartLinePlot.class.getName(), VanChartAxisScrollPaneWithTypeSelect.class);
        XAxisPaneMap.put(VanChartAreaPlot.class.getName(), VanChartAxisScrollPaneWithTypeSelect.class);
        XAxisPaneMap.put(VanChartRadarPlot.class.getName(), VanChartXAxisScrollPaneWithRadar.class);
    }

    private static void initYAxisPaneMap() {
        YAxisPaneMap.put(VanChartColumnPlot.class.getName(), VanChartAxisScrollPaneWithOutTypeSelect.class);
        YAxisPaneMap.put(VanChartLinePlot.class.getName(), VanChartAxisScrollPaneWithOutTypeSelect.class);
        YAxisPaneMap.put(VanChartAreaPlot.class.getName(), VanChartAxisScrollPaneWithOutTypeSelect.class);
        YAxisPaneMap.put(VanChartGaugePlot.class.getName(), VanChartAxisScrollPaneWithGauge.class);
        YAxisPaneMap.put(VanChartRadarPlot.class.getName(), VanChartYAxisScrollPaneWithRadar.class);
    }

    public static VanChartXYAxisPaneInterface getXAxisScrollPane(VanChartAxisPlot vanChartAxisPlot) {
        if (XAxisPaneMap.isEmpty()) {
            AxisPaneFactory.initXAxisPaneMap();
        }
        Class<? extends VanChartXYAxisPaneInterface> clazz = XAxisPaneMap.get(vanChartAxisPlot.getClass().getName());
        return AxisPaneFactory.createPane(clazz);
    }

    public static VanChartXYAxisPaneInterface getYAxisScrollPane(VanChartAxisPlot vanChartAxisPlot) {
        if (YAxisPaneMap.isEmpty()) {
            AxisPaneFactory.initYAxisPaneMap();
        }
        Class<? extends VanChartXYAxisPaneInterface> clazz = YAxisPaneMap.get(vanChartAxisPlot.getClass().getName());
        return AxisPaneFactory.createPane(clazz);
    }

    private static VanChartXYAxisPaneInterface createPane(Class<? extends VanChartXYAxisPaneInterface> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }
}

