/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.WSDL11ToAllAxisServicesBuilder;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAllAxisServicesBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CodeGenerationEngine {
    private static final Log log = LogFactory.getLog(CodeGenerationEngine.class);
    private List preExtensions = new ArrayList();
    private List postExtensions = new ArrayList();
    private CodeGenConfiguration configuration;

    public CodeGenerationEngine(CodeGenConfiguration configuration) throws CodeGenerationException {
        this.configuration = configuration;
        this.loadExtensions();
    }

    public CodeGenerationEngine(CommandLineOptionParser parser) throws CodeGenerationException {
        Map allOptions = parser.getAllOptions();
        try {
            CommandLineOption option = (CommandLineOption)allOptions.get("uri");
            String wsdlUri = option.getOptionValue();
            if (wsdlUri.startsWith("http")) {
                URL url = new URL(wsdlUri);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setInstanceFollowRedirects(false);
                connection.getResponseCode();
                String newLocation = connection.getHeaderField("Location");
                if (newLocation != null) {
                    wsdlUri = newLocation;
                }
            }
            this.configuration = new CodeGenConfiguration(allOptions);
            if ("2.0".equals(this.configuration.getWSDLVersion())) {
                WSDL20ToAllAxisServicesBuilder builder;
                if (this.configuration.getServiceName() != null || this.configuration.getDatabindingType().equals("jibx")) {
                    builder = new WSDL20ToAxisServiceBuilder(wsdlUri, this.configuration.getServiceName(), this.configuration.getPortName(), this.configuration.isAllPorts());
                    builder.setCodegen(true);
                    this.configuration.addAxisService(builder.populateService());
                } else {
                    builder = new WSDL20ToAllAxisServicesBuilder(wsdlUri, this.configuration.getPortName());
                    builder.setCodegen(true);
                    builder.setAllPorts(this.configuration.isAllPorts());
                    this.configuration.setAxisServices(builder.populateAllServices());
                }
            } else {
                Definition wsdl4jDef = this.readInTheWSDLFile(wsdlUri);
                Map imports = wsdl4jDef.getImports();
                if (imports != null && imports.size() > 0) {
                    this.configuration.setWsdlDefinition(this.readInTheWSDLFile(wsdlUri));
                } else {
                    this.configuration.setWsdlDefinition(wsdl4jDef);
                }
                QName serviceQname = null;
                if (this.configuration.getServiceName() != null) {
                    serviceQname = new QName(wsdl4jDef.getTargetNamespace(), this.configuration.getServiceName());
                }
                if (serviceQname != null || this.configuration.getDatabindingType().equals("jibx")) {
                    WSDL11ToAxisServiceBuilder builder = new WSDL11ToAxisServiceBuilder(wsdl4jDef, serviceQname, this.configuration.getPortName(), this.configuration.isAllPorts());
                    builder.setCodegen(true);
                    this.configuration.addAxisService(builder.populateService());
                } else {
                    WSDL11ToAllAxisServicesBuilder builder = new WSDL11ToAllAxisServicesBuilder(wsdl4jDef, this.configuration.getPortName());
                    builder.setCodegen(true);
                    builder.setAllPorts(this.configuration.isAllPorts());
                    this.configuration.setAxisServices(builder.populateAllServices());
                }
            }
            this.configuration.setBaseURI(this.getBaseURI(wsdlUri));
        }
        catch (AxisFault axisFault) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wsdlParsingException"), axisFault);
        }
        catch (WSDLException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wsdlParsingException"), e);
        }
        catch (Exception e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wsdlParsingException"), e);
        }
        this.loadExtensions();
    }

    private void loadExtensions() throws CodeGenerationException {
        String[] postExtensions;
        String[] extensions = ConfigPropertyFileLoader.getExtensionClassNames();
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                this.addPreExtension((CodeGenExtension)this.getObjectFromClassName(extensions[i].trim()));
            }
        }
        if ((postExtensions = ConfigPropertyFileLoader.getPostExtensionClassNames()) != null) {
            for (int i = 0; i < postExtensions.length; ++i) {
                this.addPostExtension((CodeGenExtension)this.getObjectFromClassName(postExtensions[i].trim()));
            }
        }
    }

    private void addPreExtension(CodeGenExtension ext) {
        if (ext != null) {
            this.preExtensions.add(ext);
        }
    }

    private void addPostExtension(CodeGenExtension ext) {
        if (ext != null) {
            this.postExtensions.add(ext);
        }
    }

    public void generate() throws CodeGenerationException {
        try {
            for (int i = 0; i < this.preExtensions.size(); ++i) {
                ((CodeGenExtension)this.preExtensions.get(i)).engage(this.configuration);
            }
            TypeMapper mapper = this.configuration.getTypeMapper();
            if (mapper == null) {
                throw new CodeGenerationException(CodegenMessages.getMessage("engine.noProperDatabindingException"));
            }
            Map emitterMap = ConfigPropertyFileLoader.getLanguageEmitterMap();
            String className = (String)emitterMap.get(this.configuration.getOutputLanguage());
            if (className == null) {
                throw new Exception(CodegenMessages.getMessage("engine.emitterMissing"));
            }
            Emitter emitter = (Emitter)this.getObjectFromClassName(className);
            emitter.setCodeGenConfiguration(this.configuration);
            emitter.setMapper(mapper);
            if (this.configuration.isServerSide()) {
                emitter.emitSkeleton();
                if (this.configuration.isGenerateAll()) {
                    emitter.emitStub();
                }
            } else {
                emitter.emitStub();
            }
            for (int i = 0; i < this.postExtensions.size(); ++i) {
                ((CodeGenExtension)this.postExtensions.get(i)).engage(this.configuration);
            }
        }
        catch (ClassCastException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wrongEmitter"), e);
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    public Definition readInTheWSDLFile(String uri) throws WSDLException {
        WSDLReader reader = WSDLUtil.newWSDLReaderWithPopulatedExtensionRegistry();
        reader.setFeature("javax.wsdl.importDocuments", true);
        return reader.readWSDL(uri);
    }

    private Object getObjectFromClassName(String className) throws CodeGenerationException {
        try {
            Class<?> extensionClass = this.getClass().getClassLoader().loadClass(className);
            return extensionClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)CodegenMessages.getMessage("engine.extensionLoadProblem"), (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.extensionInstantiationProblem"), e);
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.illegalExtension"), e);
        }
        catch (NoClassDefFoundError e) {
            log.debug((Object)CodegenMessages.getMessage("engine.extensionLoadProblem"), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private String getBaseURI(String currentURI) throws URISyntaxException, IOException {
        File file = new File(currentURI);
        if (file.exists()) {
            return file.getCanonicalFile().getParentFile().toURI().toString();
        }
        String uriFragment = currentURI.substring(0, currentURI.lastIndexOf("/"));
        return uriFragment + (uriFragment.endsWith("/") ? "" : "/");
    }

    private String getURI(String currentURI) throws URISyntaxException, IOException {
        File file = new File(currentURI);
        if (file.exists()) {
            return file.getCanonicalFile().toURI().toString();
        }
        return currentURI;
    }

    public CodeGenConfiguration getConfiguration() {
        return this.configuration;
    }
}

