/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.helper;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class C14nHelper {
    private C14nHelper() {
    }

    public static boolean namespaceIsRelative(Attr attr) {
        return !C14nHelper.namespaceIsAbsolute(attr);
    }

    public static boolean namespaceIsRelative(String string2) {
        return !C14nHelper.namespaceIsAbsolute(string2);
    }

    public static boolean namespaceIsAbsolute(Attr attr) {
        return C14nHelper.namespaceIsAbsolute(attr.getValue());
    }

    public static boolean namespaceIsAbsolute(String string2) {
        if (string2.length() == 0) {
            return true;
        }
        return string2.indexOf(58) > 0;
    }

    public static void assertNotRelativeNS(Attr attr) throws CanonicalizationException {
        if (attr == null) {
            return;
        }
        String string2 = attr.getNodeName();
        boolean bl = string2.equals("xmlns");
        boolean bl2 = string2.startsWith("xmlns:");
        if ((bl || bl2) && C14nHelper.namespaceIsRelative(attr)) {
            String string3 = attr.getOwnerElement().getTagName();
            String string4 = attr.getValue();
            Object[] objectArray = new Object[]{string3, string2, string4};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
    }

    public static void checkTraversability(Document document) throws CanonicalizationException {
        if (!document.isSupported("Traversal", "2.0")) {
            Object[] objectArray = new Object[]{document.getImplementation().getClass().getName()};
            throw new CanonicalizationException("c14n.Canonicalizer.TraversalNotSupported", objectArray);
        }
    }

    public static void checkForRelativeNamespace(Element element) throws CanonicalizationException {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                C14nHelper.assertNotRelativeNS((Attr)namedNodeMap.item(i));
            }
        } else {
            throw new CanonicalizationException("Called checkForRelativeNamespace() on null");
        }
    }
}

