/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.sender;

import cn.com.jshx.sender.interfaces.Sender;
import cn.com.jshx.smgp.Client;
import cn.com.jshx.smgp.bean.Result;
import cn.com.jshx.smgp.bean.Submit;
import cn.com.jshx.util.Config;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMGPSender
implements Sender {
    private static final Log logger = LogFactory.getLog(SMGPSender.class);
    private static Client client = null;
    private static final String SMGW_IP = Config.getProperty("smgp_ip");
    private static final int SMGW_PORT = Integer.parseInt(Config.getProperty("smgp_port"));
    private static final String SMGW_ACCOUNT = Config.getProperty("smgp_account");
    private static final String SMGW_PASSWD = Config.getProperty("smgp_passwd");
    private static final String SMGW_SPID = Config.getProperty("smgp_spid");
    private static final String SMGW_SPNUM = Config.getProperty("smgp_spnum");

    static {
        client = new Client(SMGW_IP, SMGW_PORT, 2, SMGW_ACCOUNT, SMGW_PASSWD, SMGW_SPID, 2);
        client.Login();
    }

    @Override
    public int send(String mobile, String content) {
        Submit submit = new Submit();
        submit.setSrcTermid(SMGW_SPNUM);
        submit.setDestTermid(mobile);
        try {
            submit.setMsgContent(content.getBytes("gb2312"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Send short message encoding format error.");
            e.printStackTrace();
        }
        submit.setMsgFormat(15);
        submit.setProductID("112000000000000001032");
        submit.setServiceID("106592052");
        submit.setChargeTermid("00000000000000000000");
        if (submit.getMsgContent().length < 200) {
            Result result = client.Send(submit);
            if (result == null) {
                logger.error((Object)("message send failed,result is null. phone:" + mobile));
                return 0xFFFFFF;
            }
            if (result.ErrorCode != 0) {
                logger.error((Object)("message send failed,phone:" + mobile));
                logger.error((Object)("description:" + result.ErrorDescription + ",ErrorCode:" + result.ErrorCode));
                return 0xFFFFFF;
            }
        } else {
            Result[] result = client.SendLong(submit);
            if (result == null) {
                logger.error((Object)("message send failed,result is null. phone:" + mobile));
                return 0xFFFFFF;
            }
            int i = 0;
            while (i < result.length) {
                if (result[i].ErrorCode != 0) {
                    logger.error((Object)("message send failed,phone:" + mobile));
                    logger.error((Object)("description:" + result[i].ErrorDescription + ",ErrorCode" + result[i].ErrorCode));
                    return 0xFFFFFF;
                }
                ++i;
            }
        }
        return 0;
    }

    @Override
    public int send(Map<String, String> map, String mobile, String content) {
        return 0;
    }
}

