/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RangeAxisGlyph
extends ValueAxisGlyph {
    private static final long serialVersionUID = -3771020074467579784L;
    private Color leftColor = new Color(215, 214, 214);
    private Color rightColor = new Color(240, 239, 239);

    public void init(Rectangle2D rectangle2D, double d) {
        this.setBounds(rectangle2D);
        this.setOrigin(new Point2D.Double(0.0, rectangle2D.getHeight() / 2.0));
        this.setAxisLength(rectangle2D.getWidth());
        this.setAxisGridLength(d);
    }

    public void dealPlotBoundsWithAxisLabel(Rectangle2D rectangle2D, int n) {
        this.dealAlertLabelWidth(n);
    }

    public void drawAxisGrid(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        super.drawAxisGrid(graphics);
        this.drawAxisGround(graphics);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawAxisGround(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Point2D.Double double_ = new Point2D.Double(0.0, this.getBounds().getHeight() / 2.0);
        Point2D.Double double_2 = new Point2D.Double(this.axisLength, this.getBounds().getHeight() / 2.0);
        graphics2D.setPaint(new GradientPaint(double_, this.leftColor, double_2, this.rightColor, true));
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, this.axisLength, this.getBounds().getHeight()));
        graphics2D.setPaint(paint);
    }

    public Line2D[] getGridLine(double d) {
        Point2D point2D = this.getPoint2D(d);
        Line2D.Double double_ = new Line2D.Double(point2D.getX(), 0.0 - this.bounds.getY(), point2D.getX(), this.plotZeroBounds.getHeight() - this.bounds.getY());
        return new Line2D[]{double_};
    }

    protected void drawLabel(Graphics graphics, double d, double d2, String string, GeneralPath generalPath, int n) {
        if (!this.isShowAxisLabel()) {
            return;
        }
        Point2D point2D = this.getPoint2D(d + d2);
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() - this.getBounds().getHeight() / 2.0 - dimension2D.getHeight() - 4.0 - 12.0, dimension2D.getWidth(), dimension2D.getHeight());
        if (this.getLabelNumber() != 0) {
            GlyphUtils.drawStrings(graphics, string, textAttr, double_, n);
        } else if (!generalPath.intersects(double_)) {
            generalPath.append(double_, false);
            GlyphUtils.drawStrings(graphics, string, textAttr, double_, n);
        }
    }

    public boolean equals(Object object) {
        return object instanceof RangeAxisGlyph && super.equals(object) && ComparatorUtils.equals((Object)((RangeAxisGlyph)object).leftColor, (Object)this.leftColor) && ComparatorUtils.equals((Object)((RangeAxisGlyph)object).rightColor, (Object)this.rightColor);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.leftColor != null) {
            jSONObject.put("leftColor", (Object)StableUtils.javaColorToCSSColor((Color)this.leftColor));
        }
        if (this.rightColor != null) {
            jSONObject.put("rightColor", (Object)StableUtils.javaColorToCSSColor((Color)this.rightColor));
        }
        return jSONObject;
    }

    public String getJSAxisType() {
        return "RangeAxisGlyph";
    }
}

