/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.XYPlot;
import com.fr.chart.chartdata.ScatterChartData;
import com.fr.chart.chartglyph.DataPoint4XY;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.XYScatterPlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class XYScatterPlot
extends XYPlot {
    private static final long serialVersionUID = 5947464168434538499L;
    public static final String XML_TAG = "XYScatterPlot";
    private static final String[] X_ITEM = new String[]{"N", "S"};
    private static final String[][] X_VALUE = new String[][]{{"10", "20", "30", "50", "60", "66", "70", "74", "83", "96", "114", "130"}, {"10", "20", "30", "50", "60", "66", "70", "74", "83", "96", "114", "130"}};
    private static final String[][] Y_VALUE = new String[][]{{"12", "15", "20", "17", "12", "14", "17", "10", "14", "20", "12", "8"}, {"3", "26", "10", "28", "27", "6", "27", "18", "9", "10", "21", "5"}};
    public static final ScatterChartData SCATTER_CHART_DATA = new ScatterChartData(X_ITEM, X_VALUE, Y_VALUE);
    private boolean isCurve = false;

    public ChartData createNullChartData() {
        return new ScatterChartData(new String[]{""}, new String[][]{{""}}, new String[][]{{""}});
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        XYScatterPlotGlyph xYScatterPlotGlyph = new XYScatterPlotGlyph();
        this.install4PlotGlyph(xYScatterPlotGlyph, chartData);
        this.installAxisGlyph(xYScatterPlotGlyph, chartData);
        return xYScatterPlotGlyph;
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        this.addSeriesByIndex(plotGlyph, scatterChartData);
    }

    protected void addSeriesByIndex(PlotGlyph plotGlyph, ScatterChartData scatterChartData) {
        for (int i = 0; i < scatterChartData.getItemCount(); ++i) {
            DataSeries dataSeries = this.createDataSeries(i);
            dataSeries.setSeriesName(Utils.objectToString((Object)scatterChartData.getPresentItem(i)));
            plotGlyph.addSeries(dataSeries);
            for (int j = 0; j < scatterChartData.getCategoryLabelCount(); ++j) {
                DataPoint4XY dataPoint4XY = new DataPoint4XY();
                dataPoint4XY.setCategoryIndex(j);
                dataPoint4XY.setSeriesIndex(i);
                if (i < scatterChartData.getItemCount() && j < scatterChartData.getCategoryLabelCount()) {
                    Number number = scatterChartData.getX(i, j);
                    Number number2 = scatterChartData.getY(i, j);
                    dataPoint4XY.setX(number == null ? 0.0 : number.doubleValue());
                    dataPoint4XY.setCategoryOriginalName("" + (number == null ? 0.0 : number.doubleValue()));
                    dataPoint4XY.setValue(number2 == null ? 0.0 : number2.doubleValue());
                    if (number == null || number2 == null) {
                        dataPoint4XY.setValueIsNull(true);
                    }
                }
                if (j < scatterChartData.getCategoryLabelCount()) {
                    // empty if block
                }
                if (i < scatterChartData.getItemCount()) {
                    dataPoint4XY.setSeriesName(Utils.objectToString((Object)scatterChartData.getPresentItem(i)));
                    dataPoint4XY.setSeriesOriginalName(Utils.objectToString((Object)scatterChartData.getOriginalItem(i)));
                }
                dataSeries.addDataPoint(dataPoint4XY);
            }
        }
        this.createDataPointLabel(plotGlyph);
    }

    public void install4PlotGlyph(XYScatterPlotGlyph xYScatterPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(xYScatterPlotGlyph, chartData);
        xYScatterPlotGlyph.setCurve(this.isCurve);
    }

    protected double getMaxValue4XValue(ChartData chartData) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        double d = 0.0;
        for (int i = 0; i < scatterChartData.getItemCount(); ++i) {
            for (int j = 0; j < scatterChartData.getCategoryLabelCount(); ++j) {
                Number number = scatterChartData.getX(i, j);
                if (number == null) continue;
                d = d > number.doubleValue() ? d : number.doubleValue();
            }
        }
        return d;
    }

    public double getMinValueFromData(ChartData chartData, boolean bl, ChartAxisPosition chartAxisPosition) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        double d = 0.0;
        if (bl) {
            d = Double.MAX_VALUE;
        }
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < scatterChartData.getItemCount(); ++j) {
                Number number = scatterChartData.getY(j, i);
                if (number == null) continue;
                d = bl ? (number.doubleValue() < d && number.doubleValue() < 1.0 && number.doubleValue() > 0.0 ? number.doubleValue() : d) : (number.doubleValue() < d ? number.doubleValue() : d);
            }
        }
        if (d == Double.MAX_VALUE) {
            return 1.0;
        }
        return d;
    }

    public double getMaxValueFromData(ChartData chartData, ChartAxisPosition chartAxisPosition) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        double d = 0.0;
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < scatterChartData.getItemCount(); ++j) {
                Number number = scatterChartData.getY(j, i);
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, j);
                if (number == null || !ComparatorUtils.equals((Object)((Object)attrAxisPosition.getAxisPosition()), (Object)((Object)chartAxisPosition))) continue;
                d = number.doubleValue() > d ? number.doubleValue() : d;
            }
        }
        if (d == this.getMinValueFromData(chartData, false, chartAxisPosition)) {
            return d + 10.0;
        }
        return d;
    }

    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        return this.getLegendMarkerIcon4Line(dataSeries, colorArray);
    }

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public boolean isCurve() {
        return this.isCurve;
    }

    public ChartData defaultChartData() {
        return SCATTER_CHART_DATA;
    }

    public boolean match4GUI(Plot plot) {
        if (plot == null && !(plot instanceof XYScatterPlot)) {
            return false;
        }
        return super.match4GUI(plot);
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof XYScatterPlot;
    }

    public boolean isSupportTrendLine() {
        return true;
    }

    public boolean isSupportCategoryFilter() {
        return false;
    }

    public boolean isSupportValuePercent() {
        return false;
    }

    public boolean isHighChart() {
        return false;
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    public String getPlotName() {
        String string = Inter.getLocText((String)"I-xyScatterStyle_Marker");
        if (this.getConditionCollection().getDefaultAttr().getExisted(AttrLineStyle.class) == null) {
            string = Inter.getLocText((String)"FR-Chart-Shape_Line") + string;
        }
        if (this.getConditionCollection() != null && this.getConditionCollection().isDefaultNullMarker()) {
            string = Inter.getLocText((String[])new String[]{"Data", "Marker"}) + string;
        }
        return string;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "XYScatterAttr".equals(string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttrAsString("showLine", null);
            if (string2 != null && !Boolean.valueOf(string2).booleanValue()) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
            }
            if ((string2 = xMLableReader.getAttrAsString("showMarker", null)) != null && !Boolean.valueOf(string2).booleanValue()) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
            }
            this.isCurve = xMLableReader.getAttrAsBoolean("Curve", false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("XYScatterAttr").attr("Curve", this.isCurve);
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof XYScatterPlot && super.equals(object) && ((XYScatterPlot)object).isCurve() == this.isCurve;
    }

    public Object clone() throws CloneNotSupportedException {
        XYScatterPlot xYScatterPlot = (XYScatterPlot)super.clone();
        xYScatterPlot.isCurve = this.isCurve();
        return xYScatterPlot;
    }

    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/xyscatter/0";
    }

    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.XYSCATTER;
    }

    public int getDetailType() {
        return 0;
    }

    public String getPlotID() {
        return "FineReportScatterChart";
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.XY_SCATTER_CHART;
    }
}

