/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.utils;

import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.QuickSelect;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Select {
    private static Select instance;
    private QuickSelect quickSelect;

    public static Select instance() {
        if (instance == null) {
            instance = new Select();
        }
        return instance;
    }

    public <T> T select(T[] TArray, Comparator<T> comparator, int n, int n2) {
        int n3 = this.selectIndex(TArray, comparator, n, n2);
        return TArray[n3];
    }

    public <T> int selectIndex(T[] TArray, Comparator<T> comparator, int n, int n2) {
        int n3;
        if (n2 < 1) {
            throw new GdxRuntimeException("cannot select from empty array (size < 1)");
        }
        if (n > n2) {
            throw new GdxRuntimeException("Kth rank is larger than size. k: " + n + ", size: " + n2);
        }
        if (n == 1) {
            n3 = this.fastMin(TArray, comparator, n2);
        } else if (n == n2) {
            n3 = this.fastMax(TArray, comparator, n2);
        } else {
            if (this.quickSelect == null) {
                this.quickSelect = new QuickSelect();
            }
            n3 = this.quickSelect.select(TArray, comparator, n, n2);
        }
        return n3;
    }

    private <T> int fastMin(T[] TArray, Comparator<T> comparator, int n) {
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            int n3 = comparator.compare(TArray[i], TArray[n2]);
            if (n3 >= 0) continue;
            n2 = i;
        }
        return n2;
    }

    private <T> int fastMax(T[] TArray, Comparator<T> comparator, int n) {
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            int n3 = comparator.compare(TArray[i], TArray[n2]);
            if (n3 <= 0) continue;
            n2 = i;
        }
        return n2;
    }
}

