/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.array.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedIntList<E>
implements Iterable<Node<E>> {
    private NodePool<E> nodePool = new NodePool();
    private Iterator iterator;
    int size = 0;
    Node<E> first;

    public E insert(int n, E e) {
        if (this.first != null) {
            Node<E> node = this.first;
            while (node.n != null && node.n.index <= n) {
                node = node.n;
            }
            if (n > node.index) {
                node.n = this.nodePool.obtain(node, node.n, e, n);
                if (node.n.n != null) {
                    node.n.n.p = node.n;
                }
                ++this.size;
            } else if (n < node.index) {
                Node<E> node2 = this.nodePool.obtain(null, this.first, e, n);
                this.first.p = node2;
                this.first = node2;
                ++this.size;
            } else {
                node.value = e;
            }
        } else {
            this.first = this.nodePool.obtain(null, null, e, n);
            ++this.size;
        }
        return null;
    }

    public E get(int n) {
        E e = null;
        if (this.first != null) {
            Node<E> node = this.first;
            while (node.n != null && node.index < n) {
                node = node.n;
            }
            if (node.index == n) {
                e = node.value;
            }
        }
        return e;
    }

    public void clear() {
        while (this.first != null) {
            this.nodePool.free(this.first);
            this.first = this.first.n;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    @Override
    public java.util.Iterator<Node<E>> iterator() {
        if (this.iterator == null) {
            this.iterator = new Iterator();
        }
        return this.iterator.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodePool<E>
    extends Pool<Node<E>> {
        NodePool() {
        }

        @Override
        protected Node<E> newObject() {
            return new Node();
        }

        public Node<E> obtain(Node<E> node, Node<E> node2, E e, int n) {
            Node node3 = (Node)super.obtain();
            node3.p = node;
            node3.n = node2;
            node3.value = e;
            node3.index = n;
            return node3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node<E> {
        protected Node<E> p;
        protected Node<E> n;
        public E value;
        public int index;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Iterator
    implements java.util.Iterator<Node<E>> {
        private Node<E> position;
        private Node<E> previousPosition;

        Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position != null;
        }

        @Override
        public Node<E> next() {
            this.previousPosition = this.position;
            this.position = this.position.n;
            return this.previousPosition;
        }

        @Override
        public void remove() {
            if (this.previousPosition != null) {
                if (this.previousPosition == SortedIntList.this.first) {
                    SortedIntList.this.first = this.position;
                } else {
                    this.previousPosition.p.n = this.position;
                    if (this.position != null) {
                        this.position.p = this.previousPosition.p;
                    }
                }
                --SortedIntList.this.size;
            }
        }

        public Iterator reset() {
            this.position = SortedIntList.this.first;
            this.previousPosition = null;
            return this;
        }
    }
}

