/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.filter.core;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtils {
    public static KeyPair generateKeyPair(int n) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", (Provider)new BouncyCastleProvider());
        keyPairGenerator.initialize(n, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static RSAPublicKey generateRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        return (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
    }

    public static RSAPrivateKey generateRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
        return (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
    }

    public static byte[] sign(byte[] byArray, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance("MD5withRSA", (Provider)new BouncyCastleProvider());
        signature.initSign(privateKey, new SecureRandom());
        signature.update(byArray);
        return signature.sign();
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance("MD5withRSA", (Provider)new BouncyCastleProvider());
        signature.initVerify(publicKey);
        signature.update(byArray);
        return signature.verify(byArray2);
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                string = '0' + string;
            }
            stringBuffer.append(string.toUpperCase());
        }
        return stringBuffer.toString();
    }

    public static byte[] hexStringToBytes(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        string = string.toUpperCase();
        int n = string.length() / 2;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            byArray[i] = (byte)(RSAUtils.charToByte(cArray[n2]) << 4 | RSAUtils.charToByte(cArray[n2 + 1]));
        }
        return byArray;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static void main(String[] stringArray) throws Exception {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                boolean bl;
                byArray[0] = (byte)i;
                byArray[1] = (byte)j;
                String string = RSAUtils.toHexString(byArray);
                byte[] byArray2 = RSAUtils.hexStringToBytes(string);
                boolean bl2 = bl = byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray2.length == 2;
                if (!bl) {
                    System.out.println(string + byArray[0] + ":" + byArray[1] + bl);
                    System.exit(0);
                }
                System.out.println(string + byArray[0] + ":" + byArray[1] + bl);
            }
        }
        System.out.println("***************");
    }
}

