/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.allocation;

import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.privilege.Authority;
import com.fr.privilege.allocation.Allocation;
import com.fr.privilege.allocation.AuthorityAllocation;
import com.fr.privilege.filter.AuthorityControlFilter;
import com.fr.privilege.filter.AuthorityRoleDAOManager;
import com.fr.stable.StringUtils;
import java.util.Arrays;

public class Allow {
    public static final String ROOT_PATH = "/root/";
    private String[] roleNames;

    public Allow() {
        this.roleNames = new String[0];
    }

    public Allow(String string) {
        this.roleNames = new String[]{string};
    }

    public Allow(String[] stringArray) {
        this.roleNames = stringArray;
    }

    public static Allocation getAllocation(String string) {
        AuthorityControlFilter authorityControlFilter = AuthorityRoleDAOManager.getAuthControlFilter(false);
        if (string == null || authorityControlFilter == null) {
            return new Allocation();
        }
        try {
            AuthorityAllocation authorityAllocation = AuthorityRoleDAOManager.getAuthorityAllocation(authorityControlFilter, string);
            if (authorityAllocation == null) {
                Allocation allocation = new Allocation();
                AuthorityRoleDAOManager.addAuthorityRole(authorityControlFilter, new Authority(string), allocation, false, false);
                return allocation;
            }
            return authorityAllocation.getAllocation();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return new Allocation();
        }
    }

    public int allowView(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n = string.lastIndexOf("/");
            String string2 = n < 1 ? ROOT_PATH : string.substring(0, n);
            int n2 = allocation.getViewCount();
            for (int j = 0; j < n2; ++j) {
                if (!StringUtils.equalsIgnore(allocation.getView(j).getPath(), string, "/") && this.allowFileFolderView(string2) != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int allowFileFolderView(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n = allocation.getViewCount();
            for (int j = 0; j < n; ++j) {
                if (StringUtils.perfectSurround(string, "/").startsWith(allocation.getView(j).getPath())) {
                    return 1;
                }
                if (!allocation.getView(j).getPath().startsWith(StringUtils.perfectEnd(string, "/"))) continue;
                return 2;
            }
        }
        return 0;
    }

    public int allowWrite(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n = string.lastIndexOf("/");
            String string2 = n < 1 ? ROOT_PATH : string.substring(0, n);
            if (string.endsWith(".frm")) {
                return 0;
            }
            int n2 = allocation.getWriteCount();
            for (int j = 0; j < n2; ++j) {
                if (!StringUtils.equalsIgnore(allocation.getWrite(j).getPath(), string, "/") && this.allowFileFolderWrite(string2) != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int allowFileFolderWrite(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n2 = allocation.getWriteCount();
            for (int j = 0; j < n2; ++j) {
                if (StringUtils.perfectSurround(string, "/").startsWith(allocation.getWrite(j).getPath())) {
                    return 1;
                }
                if (!allocation.getWrite(j).getPath().startsWith(StringUtils.perfectEnd(string, "/"))) continue;
                n = 2;
            }
        }
        return n;
    }

    public int allowDesign(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n = string.lastIndexOf("/");
            String string2 = n < 1 ? ROOT_PATH : string.substring(0, n);
            int n2 = allocation.getDesignCount();
            for (int j = 0; j < n2; ++j) {
                if (!StringUtils.equalsIgnore(allocation.getDesign(j).getPath(), string, "/") && this.allowFileFolderDesign(string2) != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int allowFileFolderDesign(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n2 = allocation.getDesignCount();
            for (int j = 0; j < n2; ++j) {
                if (StringUtils.perfectSurround(string, "/").startsWith(allocation.getDesign(j).getPath())) {
                    return 1;
                }
                if (!allocation.getDesign(j).getPath().startsWith(StringUtils.perfectEnd(string, "/"))) continue;
                n = 2;
            }
        }
        return n;
    }

    public int allowForm(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n = string.lastIndexOf("/");
            String string2 = n < 1 ? ROOT_PATH : string.substring(0, n);
            int n2 = allocation.getFormCount();
            for (int j = 0; j < n2; ++j) {
                if (!StringUtils.equalsIgnore(allocation.getForm(j).getPath(), string, "/") && this.allowFileFolderForm(string2) != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int allowFileFolderForm(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n2 = allocation.getFormCount();
            for (int j = 0; j < n2; ++j) {
                if (StringUtils.perfectSurround(string, "/").startsWith(allocation.getForm(j).getPath())) {
                    return 1;
                }
                if (!allocation.getForm(j).getPath().startsWith(StringUtils.perfectEnd(string, "/"))) continue;
                n = 2;
            }
        }
        return n;
    }

    public int allowExcelSubmit(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i = 0; i < this.roleNames.length; ++i) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i]);
            int n = string.lastIndexOf("/");
            String string2 = n < 1 ? ROOT_PATH : string.substring(0, n);
            int n2 = allocation.getExcelSubmitCount();
            for (int j = 0; j < n2; ++j) {
                if (!StringUtils.equalsIgnore(allocation.getExcelSubmit(j).getPath(), string, "/") && !StringUtils.equalsIgnore(allocation.getDesign(j).getPath(), string2, "/")) continue;
                return 1;
            }
        }
        return 0;
    }
}

