/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import Sense4.Elite4;
import Sense4.LockUtils;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.FRCoreContext;
import com.fr.general.AppContentGenerator;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginLicType;
import com.fr.plugin.PluginLicense;
import com.fr.plugin.PluginManagerHelper;
import com.fr.plugin.PluginMessage;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.LicUtils;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.Authorize;
import com.fr.stable.plugin.PluginSimplify;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class PluginLicenseManager
implements XMLable {
    private static final int TRIAL_TIME = 90;
    private static final int TIMEOUT = 0;
    private static final int MS_OF_A_DAY = 86400000;
    private static final int DAYS_OF_A_MONTH = 30;
    private static final String LOCAL_PLUGIN = "some.info";
    private static final PluginLicenseManager PLUGIN_LICENSE_MANAGER = new PluginLicenseManager();
    public HashMap<String, String> licTrialSchedule;
    public Map<String, PluginLicense> licenseMap = new HashMap<String, PluginLicense>();

    private PluginLicenseManager() {
        this.licTrialSchedule = new HashMap();
        this.readConfig();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                if (PluginLicenseManager.this.licenseMap != null && PluginLicenseManager.this.licTrialSchedule != null) {
                    PluginLicenseManager.this.licenseMap.clear();
                    PluginLicenseManager.this.licTrialSchedule.clear();
                    PluginLicenseManager.this.readConfig();
                }
            }
        });
    }

    public static PluginLicenseManager getInstance() {
        return PLUGIN_LICENSE_MANAGER;
    }

    public void registerPaid(Authorize authorize, PluginSimplify pluginSimplify) {
        this.licenseMap.put(pluginSimplify.getPluginID(), new PluginLicense(authorize, pluginSimplify.getPluginID()));
    }

    public boolean isFree(Plugin plugin) {
        return StringUtils.isBlank(this.getPluginLicenseByID(plugin.getId()).getPluginID());
    }

    public boolean readStateByID(String string) {
        PluginLicense pluginLicense = this.getPluginLicenseByID(string);
        return pluginLicense != null && pluginLicense.isAvailable();
    }

    public PluginLicense getPluginLicenseByID(String string) {
        PluginLicense pluginLicense = this.licenseMap.get(string);
        if (pluginLicense == null) {
            return PluginLicense.NULL;
        }
        return pluginLicense;
    }

    public boolean checkLic(Plugin plugin, PluginLicense pluginLicense) throws Exception {
        if (pluginLicense.isJarIntact()) {
            if (pluginLicense.isValid() && this.licTypeCheck(pluginLicense)) {
                return this.licTimeCheck(plugin, pluginLicense);
            }
            return this.trial(plugin);
        }
        pluginLicense.jarDamage();
        PluginMessage.jarDamage(plugin.getName());
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean trial(Plugin plugin) throws Exception {
        if (this.isTempOrUnregisted()) {
            PluginLicense pluginLicense = this.getPluginLicenseByID(plugin.getId());
            pluginLicense.setPluginID(plugin.getId());
            pluginLicense.setTrial(true);
            pluginLicense.setAvailable(true);
            return true;
        }
        String string = this.licTrialSchedule.get(plugin.getId());
        PluginLicense pluginLicense = this.getPluginLicenseByID(plugin.getId());
        pluginLicense.setPluginID(plugin.getId());
        pluginLicense.setTrial(true);
        if (string == null) {
            pluginLicense.setAvailable(true);
            pluginLicense.setLeftTime(90);
            this.licTrialSchedule.put(pluginLicense.getPluginID(), System.currentTimeMillis() + "");
            this.writeConfig();
            return true;
        }
        int n = Integer.parseInt(String.valueOf((System.currentTimeMillis() - Long.parseLong(string)) / 86400000L));
        if (n <= 90) {
            pluginLicense.setAvailable(true);
            pluginLicense.setLeftTime(90 - n);
            return true;
        }
        pluginLicense.setAvailable(false);
        pluginLicense.setLeftTime(0);
        String string2 = plugin.getName() + Inter.getLocText("FR-Plugin-Plug-trial_Expired") + plugin.getId();
        FRLogger.getLogger().error(string2);
        return false;
    }

    private boolean isTempOrUnregisted() {
        return ComparatorUtils.equals(FRCoreContext.getBytes(), null) || !ComparatorUtils.equals(FRCoreContext.getBytes(), null) && LicUtils.isTempLic() && !ConfigManager.getProviderInstance().isLicUseLock();
    }

    private boolean licTypeCheck(PluginLicense pluginLicense) {
        if (PluginLicType.parse(pluginLicense.getLicType()) == PluginLicType.MACHINE) {
            return this.checkMACAddress(pluginLicense.getMACAddress()) && this.checkUUID(pluginLicense.getMachineID());
        }
        if (PluginLicType.parse(pluginLicense.getLicType()) == PluginLicType.LIC_LOCK && ConfigManager.getProviderInstance().isLicUseLock()) {
            try {
                String string = LockUtils.toHexString((byte[])Elite4.readElite4Serial());
                return ComparatorUtils.equals(string, pluginLicense.getLicLock());
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        if (PluginLicType.parse(pluginLicense.getLicType()) == PluginLicType.PROJECT) {
            String string = AppContentGenerator.generateAppContent();
            return ComparatorUtils.equals(string, pluginLicense.getProjectID());
        }
        return false;
    }

    public boolean checkMACAddress(String string) {
        try {
            String[] stringArray;
            for (String string2 : stringArray = GeneralUtils.getMacAddresses()) {
                if (!ComparatorUtils.equals(string2, string)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        return false;
    }

    public boolean checkUUID(String string) {
        return ComparatorUtils.equals(GeneralUtils.getUUID(), string);
    }

    private boolean licTimeCheck(Plugin plugin, PluginLicense pluginLicense) throws Exception {
        int n;
        int n2;
        String string = pluginLicense.getStartTime();
        if (string != null) {
            n2 = Integer.parseInt(String.valueOf((System.currentTimeMillis() - Long.parseLong(string)) / 86400000L));
            if (n2 > (n = Integer.parseInt(pluginLicense.getPluginLife()) * 30)) {
                pluginLicense.setAvailable(false);
                pluginLicense.setLeftTime(0);
                String string2 = plugin.getName() + Inter.getLocText("FR-Plugin-Plug_Expired") + plugin.getId();
                FRLogger.getLogger().error(string2);
                return false;
            }
        } else {
            return false;
        }
        pluginLicense.setAvailable(true);
        pluginLicense.setLeftTime(n - n2);
        return true;
    }

    public void writeConfig() {
        File file = new File(StableUtils.pathJoin(ProductConstants.getEnvHome(), LOCAL_PLUGIN));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(printWriter);
            xMLPrintWriter.startTAG("pluginID");
            for (Map.Entry<String, String> entry : this.licTrialSchedule.entrySet()) {
                xMLPrintWriter.startTAG(entry.getKey()).textNode(entry.getValue()).end();
            }
            xMLPrintWriter.end();
            xMLPrintWriter.flush();
            xMLPrintWriter.close();
            printWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
            PluginManagerHelper.fileEncrypt(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FRContext.getLogger().error(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
        }
    }

    public PluginLicense[] getPluginLicenses() {
        return this.licenseMap.values().toArray(new PluginLicense[this.licenseMap.size()]);
    }

    private void readConfig() {
        try {
            File file = new File(StableUtils.pathJoin(ProductConstants.getEnvHome(), LOCAL_PLUGIN));
            if (!file.exists()) {
                return;
            }
            ByteArrayInputStream byteArrayInputStream = PluginManagerHelper.XMLLileDecrypt(file);
            if (byteArrayInputStream != null) {
                XMLTools.readInputStreamXML(this, byteArrayInputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addRemotePluginLicense(PluginLicense pluginLicense) {
        this.licenseMap.put(pluginLicense.getPluginID(), pluginLicense);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            String string2 = xMLableReader.getElementValue();
            this.licTrialSchedule.put(string, string2);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

