/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.data;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;

public abstract class TableDataColumn
implements Serializable,
Cloneable {
    protected transient Integer realColumnIndex = null;

    private TableDataColumn() {
    }

    public static TableDataColumn createColumn(String string) {
        return new ColumnName(string);
    }

    public static TableDataColumn createColumn(int n) {
        return new ColumnIndex(n);
    }

    public abstract int getColumnIndex(DataModel var1, CalculatorProvider var2);

    public static String getColumnName(TableDataColumn tableDataColumn) {
        if (tableDataColumn == null) {
            return null;
        }
        if (tableDataColumn instanceof ColumnName) {
            return ((ColumnName)tableDataColumn).getName();
        }
        return tableDataColumn.toString();
    }

    public static boolean isFirstColumn(TableDataColumn tableDataColumn, DataModel dataModel) {
        try {
            if (dataModel == null || dataModel.getColumnCount() <= 0) {
                return false;
            }
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            return false;
        }
        if (tableDataColumn instanceof ColumnIndex) {
            return ((ColumnIndex)tableDataColumn).getIndex() == 0;
        }
        if (tableDataColumn instanceof ColumnName) {
            try {
                return ComparatorUtils.tableDataColumnNameEquals(((ColumnName)tableDataColumn).getName(), dataModel.getColumnName(0));
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
                return false;
            }
        }
        return false;
    }

    public static boolean isLastColumn(TableDataColumn tableDataColumn, DataModel dataModel) {
        if (dataModel == null) {
            return false;
        }
        int n = 0;
        try {
            n = dataModel.getColumnCount();
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        if (n <= 0) {
            return false;
        }
        if (tableDataColumn instanceof ColumnIndex) {
            return ((ColumnIndex)tableDataColumn).getIndex() == n - 1;
        }
        if (tableDataColumn instanceof ColumnName) {
            try {
                return ComparatorUtils.tableDataColumnNameEquals(((ColumnName)tableDataColumn).getName(), dataModel.getColumnName(n - 1));
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
                return false;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static TableDataColumn readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("columnName", null);
        if (string != null) {
            return TableDataColumn.createColumn(string);
        }
        string = xMLableReader.getAttrAsString("ci", null);
        if (string != null) {
            return TableDataColumn.createColumn(Integer.parseInt(string));
        }
        string = xMLableReader.getAttrAsString("columnIndex", null);
        if (string != null) {
            return TableDataColumn.createColumn(Integer.parseInt(string) + 1);
        }
        return null;
    }

    public static void writeXML(XMLPrintWriter xMLPrintWriter, TableDataColumn tableDataColumn) {
        if (tableDataColumn instanceof ColumnIndex) {
            xMLPrintWriter.attr("ci", ((ColumnIndex)tableDataColumn).index);
        } else if (tableDataColumn instanceof ColumnName) {
            xMLPrintWriter.attr("columnName", ((ColumnName)tableDataColumn).name);
        }
    }

    private static class ColumnName
    extends TableDataColumn {
        private String name;

        public ColumnName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public int getColumnIndex(DataModel dataModel, CalculatorProvider calculatorProvider) {
            if (this.realColumnIndex == null) {
                if (this.name.startsWith("=")) {
                    try {
                        Object object = calculatorProvider.evalValue(this.name.substring(1));
                        if (object instanceof Number) {
                            return ColumnName.createColumn(((Number)object).intValue()).getColumnIndex(dataModel, calculatorProvider);
                        }
                        return ColumnName.createColumn(GeneralUtils.objectToString(object)).getColumnIndex(dataModel, calculatorProvider);
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    }
                }
                this.realColumnIndex = new Integer(Integer.MIN_VALUE);
                if (this.name.matches("^#\\d+$")) {
                    this.realColumnIndex = new Integer(ColumnName.createColumn(Integer.parseInt(this.name.substring(1))).getColumnIndex(dataModel, calculatorProvider));
                } else {
                    int n = 0;
                    try {
                        n = dataModel.getColumnCount();
                    }
                    catch (TableDataException tableDataException) {
                        FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
                    }
                    for (int i = 0; i < n; ++i) {
                        try {
                            if (!ComparatorUtils.tableDataColumnNameEquals(this.name, dataModel.getColumnName(i))) continue;
                            this.realColumnIndex = new Integer(i);
                            break;
                        }
                        catch (TableDataException tableDataException) {
                            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
                        }
                    }
                    if (this.realColumnIndex.compareTo(new Integer(Integer.MIN_VALUE)) == 0) {
                        FRLogger.getLogger().error(Inter.getLocText(new String[]{"not-found", "DataColumn"}) + " " + this.name);
                    }
                }
            }
            return this.realColumnIndex;
        }

        public boolean equals(Object object) {
            return object instanceof ColumnName && ((ColumnName)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ColumnIndex
    extends TableDataColumn {
        private int index;

        public ColumnIndex(int n) {
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public int getColumnIndex(DataModel dataModel, CalculatorProvider calculatorProvider) {
            if (this.realColumnIndex == null) {
                this.realColumnIndex = new Integer(Integer.MIN_VALUE);
                try {
                    if (this.index >= 0 && this.index <= dataModel.getColumnCount()) {
                        this.realColumnIndex = new Integer(this.index - 1);
                    }
                }
                catch (TableDataException tableDataException) {
                    FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
                }
            }
            return this.realColumnIndex;
        }

        public boolean equals(Object object) {
            return object instanceof ColumnIndex && ((ColumnIndex)object).index == this.index;
        }

        public int hashCode() {
            return this.index;
        }

        public String toString() {
            return "#" + this.index;
        }
    }
}

