/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.GeneralUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.ArrayProvider;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.js.WidgetName;
import com.fr.stable.xml.ObjectXMLWriter;
import com.fr.stable.xml.ObjectXMLWriterFinder;
import com.fr.stable.xml.XML;
import com.fr.stable.xml.XMLPrintWriter;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class BaseObjectXMLWriterFinder
implements ObjectXMLWriterFinder {
    public ObjectXMLWriter as(Object object) {
        if (object == null || object == Primitive.NULL) {
            return new NULL();
        }
        if (object instanceof Boolean) {
            return new BOOLEAN((Boolean)object);
        }
        if (object instanceof Integer) {
            return new INTEGER((Integer)object);
        }
        if (object instanceof Long) {
            return new LONG((Long)object);
        }
        if (object instanceof Double) {
            return new DOUBLE((Double)object);
        }
        if (object instanceof Float) {
            return new FLOAT((Float)object);
        }
        if (object instanceof BigInteger) {
            return new BIGI((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return new BIGD((BigDecimal)object);
        }
        if (object instanceof Date) {
            return new DATE((Date)object);
        }
        if (object instanceof Image) {
            return new IMAGE((Image)object);
        }
        if (object instanceof ArrayProvider) {
            return new FARRAYXML((ArrayProvider)object);
        }
        if (object instanceof FormulaProvider) {
            if (((FormulaProvider)object).getXmlTag().equals("TFC")) {
                return new RESULTFORMULA((FormulaProvider)object);
            }
            return new FORMULA((FormulaProvider)object);
        }
        if (object instanceof ParameterProvider) {
            return new PARA((ParameterProvider)object);
        }
        if (object instanceof WidgetName) {
            return new WIDGETNAME((WidgetName)object);
        }
        return new ElseAsString(object);
    }

    public static class ElseAsString
    extends ObjectXMLWriter {
        private Object ob;

        public ElseAsString(Object object) {
            this.ob = object;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.textNode(StableUtils.writeSpecialString(GeneralUtils.objectToString(this.ob)));
        }
    }

    private static class PARA
    extends XML {
        PARA(ParameterProvider parameterProvider) {
            this.xml = parameterProvider;
        }

        public String type() {
            return "Parameter";
        }
    }

    private static class RESULTFORMULA
    extends XML {
        RESULTFORMULA(FormulaProvider formulaProvider) {
            this.xml = formulaProvider;
        }

        public String type() {
            return "RFormula";
        }

        public String className() {
            String string = this.xml.getClass().getName();
            if (string.endsWith(".ResultFormula")) {
                string = "RFormula";
            }
            return string;
        }
    }

    private static class FORMULA
    extends XML {
        FORMULA(FormulaProvider formulaProvider) {
            this.xml = formulaProvider;
        }

        public String type() {
            return "Formula";
        }

        public String className() {
            String string = this.xml.getClass().getName();
            if (string.endsWith(".Formula")) {
                string = "Formula";
            }
            return string;
        }
    }

    private static class WIDGETNAME
    extends XML {
        public WIDGETNAME(WidgetName widgetName) {
            this.xml = widgetName;
        }

        public String type() {
            return "WidgetName";
        }

        public String className() {
            String string = this.xml.getClass().getName();
            if (string.endsWith(".WidgetName")) {
                string = "WidgetName";
            }
            return string;
        }
    }

    private static class FARRAYXML
    extends XML {
        public FARRAYXML(ArrayProvider arrayProvider) {
            this.xml = arrayProvider;
        }

        public String type() {
            return "FARRAY";
        }
    }

    private static class IMAGE
    extends ObjectXMLWriter {
        private Image im;

        IMAGE(Image image) {
            this.im = image;
        }

        public String type() {
            return "Image";
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            GeneralXMLTools.writeImage(xMLPrintWriter, this.im);
        }
    }

    private static class DATE
    extends ObjectXMLWriter {
        private Date d;

        DATE(Date date) {
            this.d = date;
        }

        public String type() {
            return "Date";
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.textNode(String.valueOf(this.d.getTime()));
        }
    }

    private static class BIGD
    extends ToString {
        BIGD(BigDecimal bigDecimal) {
            this.ob = bigDecimal;
        }

        public String type() {
            return "BigDecimal";
        }
    }

    private static class BIGI
    extends ToString {
        BIGI(BigInteger bigInteger) {
            this.ob = bigInteger;
        }

        public String type() {
            return "BigInteger";
        }
    }

    private static class FLOAT
    extends ToString {
        FLOAT(Float f) {
            this.ob = f;
        }

        public String type() {
            return "F";
        }
    }

    private static class DOUBLE
    extends ToString {
        DOUBLE(Double d) {
            this.ob = d;
        }

        public String type() {
            return "D";
        }
    }

    private static class LONG
    extends ToString {
        LONG(Long l) {
            this.ob = l;
        }

        public String type() {
            return "L";
        }
    }

    private static class INTEGER
    extends ToString {
        INTEGER(Integer n) {
            this.ob = n;
        }

        public String type() {
            return "I";
        }
    }

    private static class BOOLEAN
    extends ToString {
        BOOLEAN(Boolean bl) {
            this.ob = bl;
        }

        public String type() {
            return "B";
        }
    }

    public static abstract class ToString
    extends ObjectXMLWriter {
        protected Object ob;

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.textNode(this.ob.toString());
        }
    }

    private static class NULL
    extends ObjectXMLWriter {
        private NULL() {
        }

        public String type() {
            return "NULL";
        }
    }
}

