/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.general.FArray;
import com.fr.general.script.FunctionHelper;
import com.fr.script.AbstractFunction;
import com.fr.stable.Primitive;

public class CORREL
extends AbstractFunction {
    public Object run(Object[] objectArray) {
        if (objectArray.length == 2) {
            try {
                FArray fArray = (FArray)objectArray[0];
                FArray fArray2 = (FArray)objectArray[1];
                return this.run(fArray, fArray2);
            }
            catch (Exception exception) {
                return Primitive.ERROR_VALUE;
            }
        }
        return Primitive.ERROR_VALUE;
    }

    private Object run(FArray fArray, FArray fArray2) {
        this.dealWithNumber(fArray);
        this.dealWithNumber(fArray2);
        if (fArray.length() != fArray2.length()) {
            return Primitive.ERROR_VALUE;
        }
        double[] dArray = new double[fArray.length()];
        double[] dArray2 = new double[fArray2.length()];
        int n = fArray.length();
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.parseDouble(fArray.elementAt(i).toString());
            dArray2[i] = Double.parseDouble(fArray2.elementAt(i).toString());
        }
        double d = this.average(dArray);
        double d2 = this.average(dArray2);
        double d3 = this.variance(dArray, dArray2, d, d2);
        double d4 = this.variance(dArray, dArray, d, d);
        double d5 = this.variance(dArray2, dArray2, d2, d2);
        double d6 = d3 / (Math.sqrt(d4) * Math.sqrt(d5));
        return FunctionHelper.asNumber(d6);
    }

    private void dealWithNumber(FArray fArray) {
        for (int i = 0; i < fArray.length(); ++i) {
            try {
                Double.parseDouble(fArray.elementAt(i).toString());
                continue;
            }
            catch (Exception exception) {
                fArray.removeElement(i);
            }
        }
    }

    private double average(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    private double variance(double[] dArray, double[] dArray2, double d, double d2) {
        double d3 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d3 += (dArray[i] - d) * (dArray2[i] - d2);
        }
        return d3;
    }

    public String getCN() {
        return "CORREL(array1,array2): \u6c42\u4e24\u4e2a\u76f8\u540c\u957f\u5ea6\u6570\u636e\u7cfb\u5217\u7684\u76f8\u5173\u7cfb\u6570(\u4e0eExcel\u7684\u540c\u540d\u51fd\u6570\u4f5c\u7528\u76f8\u540c)\u3002\n\u5982\u679c\u6570\u7ec4\u6216\u5f15\u7528\u53c2\u6570\u5305\u542b\u6587\u672c\u3001\u903b\u8f91\u503c\u6216\u7a7a\u767d\u5355\u5143\u683c\uff0c\u5219\u8fd9\u4e9b\u503c\u5c06\u88ab\u5ffd\u7565\uff1b\u4f46\u5305\u542b\u96f6\u503c\u7684\u5355\u5143\u683c\u5c06\u8ba1\u7b97\u5728\u5185\u3002\n\u51fd\u6570\u8ba1\u7b97\u7ed3\u679c\u51fa\u73b0\u8d1f\u6570\u8868\u793a\u8d1f\u76f8\u5173\u3002\u76f8\u5173\u7cfb\u6570\u7684\u53d6\u503c\u8303\u56f4\u662f[-1,1]\u4e4b\u95f4\u7684\u6570\u3002\u76f8\u5173\u7cfb\u6570\u7684\u7edd\u5bf9\u503c\u8d8a\u5927\uff0c\u8868\u793a\u8bef\u5dee\u8d8a\u5c0f\u3002 Array1 \u548c Array2 \u7684\u6570\u636e\u70b9\u7684\u4e2a\u6570\u5fc5\u987b\u76f8\u540c\uff0c\u4f8b\u5982\uff1a\nCORREL([1,2,3],[2,4,6])=1\u3002\n";
    }

    public String getEN() {
        return "CORREL(array1,array2): Calculate the correlation coefficient between two series.(the same with function in Excel)\n\nExample:\n   CORREL([1,2,3],[2,4,6]) the correlation coefficient is 1.\n";
    }
}

