/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableData;
import com.fr.base.Utils;
import com.fr.data.Dictionary;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.JQNode;
import com.fr.data.impl.RecursionDataModel;
import com.fr.data.impl.TableDataDictionary;
import com.fr.data.impl.TreeAttr;
import com.fr.data.impl.TreeNodeAttr;
import com.fr.data.impl.TreeNodeWrapper;
import com.fr.form.data.DataBinding;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.DictContainedCustomWriteAbleEditor;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.TreeComboBoxDataFilter;
import com.fr.form.ui.WidgetValue;
import com.fr.form.ui.tree.LayerConfig;
import com.fr.form.ui.tree.TreeComboboxData;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.NameObject;
import com.fr.general.data.Condition;
import com.fr.general.data.TableDataException;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONUtils;
import com.fr.script.Calculator;
import com.fr.script.TreeLayerNameSpace;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeEditor
extends DictContainedCustomWriteAbleEditor
implements DataControl {
    protected static final String EVENT_NODE_ADD = "nodeadd";
    protected TreeAttr treeAttr = new TreeAttr(false);
    protected TreeNodeAttr[] treeNodeAttr;
    private List treeNodeList = new ArrayList();
    private boolean isAutoBuild = false;
    private TableData tableData;
    private Object nodeOrDict;
    private WidgetValue widgetValue;
    private boolean isPerformanceFirst = false;
    private boolean isLayerBuild;
    private List<LayerConfig> layerConfigs;
    private JSONObject joData;
    private RecursionDataModel cacheDataModel;
    private int start = 0;
    private int limit = 0;
    private int count = 0;

    public boolean isLayerBuild() {
        return this.isLayerBuild;
    }

    public boolean isPerformanceFirst() {
        return this.isPerformanceFirst;
    }

    public void setPerformanceFirst(boolean bl) {
        this.isPerformanceFirst = bl;
    }

    @Override
    public String getXType() {
        return "tree";
    }

    public void setLayerBuild(boolean bl) {
        this.isLayerBuild = bl;
    }

    public List<LayerConfig> getLayerConfigs() {
        return this.layerConfigs;
    }

    public void setLayerConfigs(List<LayerConfig> list) {
        this.layerConfigs = list;
    }

    @Override
    public String[] supportedEvents() {
        return new String[]{"afterinit", "click", EVENT_NODE_ADD};
    }

    @Override
    public boolean isEditor() {
        return false;
    }

    @Override
    public boolean hasDataOnInit() {
        return true;
    }

    public TreeAttr getTreeAttr() {
        return this.treeAttr;
    }

    public void setTreeAttr(TreeAttr treeAttr) {
        this.treeAttr = treeAttr;
    }

    public TreeNodeAttr[] getTreeNodeAttr() {
        return this.treeNodeAttr;
    }

    public void setTreeNodeAttr(TreeNodeAttr[] treeNodeAttrArray) {
        this.treeNodeAttr = treeNodeAttrArray;
    }

    public boolean isMultipleSelection() {
        return this.treeAttr.isMultipleSelection();
    }

    public void setMultipleSelection(boolean bl) {
        this.treeAttr.setMultipleSelection(bl);
    }

    public boolean isSelectLeafOnly() {
        return this.treeAttr.isSelectLeafOnly();
    }

    public boolean isReturnFullPath() {
        return this.treeAttr.isReturnFullPath();
    }

    public void setSelectLeafOnly(boolean bl) {
        this.treeAttr.setSelectLeafOnly(bl);
    }

    public void setReturnFullPath(boolean bl) {
        this.treeAttr.setReturnFullPath(bl);
    }

    public boolean isAjax() {
        return this.treeAttr.isAjax();
    }

    public void setAjax(boolean bl) {
        this.treeAttr.setAjax(bl);
    }

    @Override
    public String[] dependence(CalculatorProvider calculatorProvider) {
        String[] stringArray = new String[]{};
        if (this.isLayerBuild) {
            return this.layerBuildDependence(calculatorProvider);
        }
        if (this.treeNodeAttr != null) {
            int n = this.treeNodeAttr.length;
            for (int i = 0; i < n; ++i) {
                Dictionary dictionary = this.treeNodeAttr[i].getDictionary();
                if (dictionary == null) continue;
                stringArray = ArrayUtils.addAll(dictionary.dependence(calculatorProvider), stringArray);
            }
        }
        if (this.dictionary != null) {
            return ArrayUtils.addAll(this.dictionary.dependence(calculatorProvider), stringArray);
        }
        return stringArray;
    }

    private String[] layerBuildDependence(CalculatorProvider calculatorProvider) {
        HashSet<String> hashSet = new HashSet<String>();
        for (LayerConfig layerConfig : this.layerConfigs) {
            hashSet.addAll(layerConfig.getDataModelParam(calculatorProvider));
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        if (this.isLayerBuild()) {
            return this.createJSONDataByLayerBuild(calculator, httpServletRequest);
        }
        boolean bl = WebUtils.getHTTPRequestBoolParameter(httpServletRequest, "tree_forceLoadComplete");
        if (StringUtils.isNotEmpty(WebUtils.getHTTPRequestParameter(httpServletRequest, "dataFilter"))) {
            return JQNode.QNode.createTreeNode(this.generatedFilterTreeData(sessionIDInfor, calculator, httpServletRequest));
        }
        if (this.getTreeAttr().isAjax() && !bl) {
            return this.loadAjaxTreeData(sessionIDInfor, calculator, httpServletRequest);
        }
        return this.loadDirectTreeData(sessionIDInfor, calculator, httpServletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray createJSONDataByLayerBuild(Calculator calculator, HttpServletRequest httpServletRequest) throws TableDataException, JSONException {
        TreeEditor treeEditor = this;
        synchronized (treeEditor) {
            if ("true".equalsIgnoreCase(WebUtils.getHTTPRequestParameter(httpServletRequest, "reload"))) {
                calculator.pushNameSpace(new FieldEditor.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
            }
            String string = this.getFilter(httpServletRequest);
            TreeComboboxData treeComboboxData = new TreeComboboxData(this.cloneLayerConfig(), string, this.treeAttr, this.isRemoveRepeat());
            treeComboboxData.init(calculator);
            return new JSONArray(treeComboboxData.toJSONString());
        }
    }

    private List<LayerConfig> cloneLayerConfig() {
        ArrayList<LayerConfig> arrayList = new ArrayList<LayerConfig>();
        for (LayerConfig layerConfig : this.layerConfigs) {
            arrayList.add((LayerConfig)layerConfig.clone());
        }
        return arrayList;
    }

    private String getFilter(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "dataFilter");
        return string;
    }

    @Override
    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        if (this.widgetValue == null) {
            this.widgetValue = new WidgetValue();
        }
        Object object = this.widgetValue.createAttrResult(new WidgetValue.WidgetValueInfo(this.getWidgetName(), this.isMultipleSelection(), this.isRemoveRepeat()), calculator, jSONObject2);
        try {
            JSONObject jSONObject3 = this.createJSONDataByDefaultValue(object, calculator);
            if (this.widgetName != null) {
                jSONObject.put(this.widgetName.toUpperCase(), jSONObject3);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("render", true);
        try {
            jSONObject.put("autoMode", true);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        jSONObject.put("mode", "remote");
        jSONObject.put("async", this.treeAttr.isAjax());
        jSONObject.put("mutiSelection", this.treeAttr.isMultipleSelection());
        jSONObject.put("delimiter", this.getDelimiter());
        jSONObject.put("selectLeafOnly", this.treeAttr.isSelectLeafOnly());
        jSONObject.put("returnFullPath", this.treeAttr.isReturnFullPath());
        Object[] objectArray = this.dependence(calculator);
        if (!ArrayUtils.isEmpty(objectArray)) {
            jSONObject.put("dependence", objectArray);
        }
        if (this.joData != null) {
            jSONObject.put("controlAttr", this.joData);
            this.joData = null;
        }
        if (nodeVisitor != null) {
            nodeVisitor.visit("needcache", jSONObject);
        }
        return jSONObject;
    }

    private String getDelimiter() {
        return this.treeAttr.isMultipleSelection() ? ";" : ",";
    }

    private JSONObject createJSONDataByDefaultValue(Object object, Calculator calculator) throws Exception {
        this.joData = new JSONObject();
        this.joData.put("value", object == null ? "" : object);
        if (object == null || object.toString().length() == 0) {
            return this.joData;
        }
        List list = this.generatedDirectTreeData(new HashMap(), calculator, "", this.getTreeAttr().isAjax() ? object : null, null);
        this.joData.put("data", JQNode.QNode.createTreeNode(list, this.isAjax()));
        String[] stringArray = ArrayUtils.addAll(this.widgetValue.dependence(calculator), this.dependence(calculator));
        if (stringArray.length > 0) {
            JSONObject jSONObject = new JSONObject();
            for (int i = 0; i < stringArray.length; ++i) {
                jSONObject.put(stringArray[i].toUpperCase(), calculator.evalValue("$" + stringArray[i]));
            }
            this.joData.put("dependence", jSONObject);
        }
        return this.joData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray loadAjaxTreeData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "value");
        String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "parent_values");
        int n = 0;
        if (string != null) {
            n = string.split("-").length;
        }
        FieldEditor.DependenceNameSpace dependenceNameSpace = null;
        this.createData(string2, sessionIDInfor, n, string, string3, calculator);
        String string4 = WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence");
        dependenceNameSpace = new FieldEditor.DependenceNameSpace(string4);
        calculator.pushNameSpace(dependenceNameSpace);
        try {
            JSONArray jSONArray = this.loadAjaxTreeNode(sessionIDInfor, string, string2, n, calculator, httpServletRequest);
            return jSONArray;
        }
        finally {
            calculator.removeNameSpace(dependenceNameSpace);
        }
    }

    private void createData(String string, SessionIDInfor sessionIDInfor, int n, String string2, String string3, Calculator calculator) throws JSONException {
        if (string != null) {
            HashMap<String, String> hashMap = (HashMap<String, String>)sessionIDInfor.getAttribute("layerMap");
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                sessionIDInfor.setAttribute("layerMap", hashMap);
            }
            hashMap.put("LAYER" + Integer.toString(n), string);
            if (string2 != null) {
                JSONArray jSONArray = JSONArray.create();
                if (string3 != null && string3.startsWith("[") && string3.endsWith("]")) {
                    jSONArray = new JSONArray(string3);
                }
                for (int i = 0; i < n - 1; ++i) {
                    Object[] objectArray = (String[])ArrayUtils.subarray(string2.split("-"), 0, i + 1);
                    if (i < jSONArray.length()) {
                        hashMap.put(StableUtils.join(objectArray, "-"), (String)jSONArray.get(i));
                    }
                    hashMap.put("LAYER" + Integer.toString(i + 1), (String)hashMap.get(StableUtils.join(objectArray, "-")));
                }
            }
            TreeLayerNameSpace treeLayerNameSpace = new TreeLayerNameSpace(hashMap);
            calculator.pushNameSpace(treeLayerNameSpace);
        }
    }

    private JSONArray loadAjaxTreeNode(SessionIDInfor sessionIDInfor, String string, String string2, int n, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        this.initStartLimit(httpServletRequest);
        if (this.getTreeNodeAttr() != null) {
            return this.loadAjaxTreeNodeByLayerBuild(sessionIDInfor, string, n, calculator, httpServletRequest);
        }
        if (this.getDictionary() != null) {
            return this.loadAjaxTreeNodeByAutoBuild(string, string2, calculator, httpServletRequest);
        }
        return null;
    }

    private JSONArray loadAjaxTreeNodeByLayerBuild(SessionIDInfor sessionIDInfor, String string, int n, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        if (n >= this.getTreeNodeAttr().length) {
            return null;
        }
        TreeNodeAttr treeNodeAttr = this.getTreeNodeAttr()[n];
        ArrayList arrayList = new ArrayList();
        this.produceAjaxTreeNode(sessionIDInfor, treeNodeAttr, string, n, arrayList, calculator, httpServletRequest);
        return JQNode.toJSONArray(arrayList);
    }

    private RecursionDataModel getDataModel(Calculator calculator) {
        if (this.cacheDataModel == null) {
            this.cacheDataModel = this.createDataModel(calculator);
        }
        return this.cacheDataModel;
    }

    private RecursionDataModel createDataModel(Calculator calculator) {
        return (RecursionDataModel)this.getDictionary().getTableData().createDataModel(calculator);
    }

    private boolean shouldRefreshDataModel(String string) {
        if (string == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.length() > 0) {
                return true;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return false;
    }

    private void refreshDataModel(Calculator calculator) {
        this.cacheDataModel = this.createDataModel(calculator);
    }

    private JSONArray loadAjaxTreeNodeByAutoBuild(String string, String string2, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        ArrayList<JQNode> arrayList = new ArrayList<JQNode>();
        int n = 0;
        if (string != null) {
            n = string.split("-").length;
        }
        TableDataDictionary tableDataDictionary = this.getDictionary();
        if (this.shouldRefreshDataModel(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence"))) {
            this.refreshDataModel(calculator);
        }
        RecursionDataModel recursionDataModel = this.getDataModel(calculator);
        Object[][] objectArray = recursionDataModel.getValuePath();
        int n2 = 1;
        Object object = this.getIDByValue(tableDataDictionary, string2, calculator);
        int n3 = recursionDataModel.getRowCount();
        for (int i = 0; i < n3; ++i) {
            Object[] objectArray2 = objectArray[i];
            if (!this.needToAddNode(objectArray2, n, object)) continue;
            String string3 = string == null ? n2 + "" : string + "-" + n2;
            int n4 = tableDataDictionary.getValueColumnIndex(recursionDataModel);
            int n5 = tableDataDictionary.getKeyColumnIndex(recursionDataModel);
            String string4 = recursionDataModel.getValueAt(i, n5).toString();
            String string5 = recursionDataModel.getValueAt(i, n4).toString();
            boolean bl = recursionDataModel.hasChildren(i);
            JQNode jQNode = new JQNode(string3, string4, string5, bl);
            arrayList.add(jQNode);
            ++n2;
        }
        if (this.start >= 0 && this.limit != 0 && this.start >= arrayList.size()) {
            return JSONArray.create();
        }
        return JQNode.toJSONArray(arrayList);
    }

    private void initStartLimit(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "startIndex");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "limitIndex");
        try {
            this.start = Integer.parseInt(string);
            this.limit = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean needToAddNode(Object[] objectArray, int n, Object object) {
        return RecursionDataModel.getNotNullLength(objectArray) == n + 1 && (n == 0 || ComparatorUtils.equals(objectArray[n - 1], object));
    }

    private Object getIDByValue(TableDataDictionary tableDataDictionary, String string, Calculator calculator) throws Exception {
        if (string == null) {
            return null;
        }
        RecursionDataModel recursionDataModel = this.getDataModel(calculator);
        int n = recursionDataModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            int n2 = tableDataDictionary.getKeyColumnIndex(recursionDataModel);
            if (!ComparatorUtils.equals((Object)string, recursionDataModel.getValueAt(i, n2))) continue;
            return recursionDataModel.getValueAt(i, recursionDataModel.getMarkField());
        }
        return null;
    }

    private void produceAjaxTreeNode(SessionIDInfor sessionIDInfor, TreeNodeAttr treeNodeAttr, String string, int n, List list, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        ParameterMapNameSpace parameterMapNameSpace = null;
        FieldEditor.DependenceNameSpace dependenceNameSpace = null;
        if ("true".equalsIgnoreCase(WebUtils.getHTTPRequestParameter(httpServletRequest, "reload"))) {
            parameterMapNameSpace = ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute());
            dependenceNameSpace = new FieldEditor.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence"));
            calculator.pushNameSpace(parameterMapNameSpace);
            calculator.pushNameSpace(dependenceNameSpace);
        }
        treeNodeAttr.getDictionary().reset();
        Iterator iterator = treeNodeAttr.getDictionary().entrys(calculator);
        Condition condition = treeNodeAttr.getDictionary().getCondition();
        HashMap hashMap = (HashMap)sessionIDInfor.getAttribute("layerMap");
        if (hashMap == null) {
            hashMap = new HashMap();
            sessionIDInfor.setAttribute("layerMap", hashMap);
        }
        this.produceAjaxTreeNodeIntoList(list, iterator, hashMap, n, condition, string, calculator);
        calculator.removeNameSpace(parameterMapNameSpace);
        calculator.removeNameSpace(dependenceNameSpace);
    }

    private void produceAjaxTreeNodeIntoList(List list, Iterator iterator, Map map, int n, Condition condition, String string, Calculator calculator) throws Exception {
        int n2 = 1;
        int n3 = 0;
        HashSet<Dictionary.MV> hashSet = new HashSet<Dictionary.MV>();
        int n4 = 0;
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            if (this.limit != 0 && n4 >= this.limit) break;
            Object object = mV.getModel();
            map.put("LAYER" + (n + 1), object);
            Object object2 = mV.getView();
            if (condition != null && !condition.eval(object, calculator)) continue;
            String string2 = null;
            string2 = n == 0 ? "" + n2 : string + "-" + n2;
            if (this.isRemoveRepeat()) {
                if (!hashSet.contains(mV)) {
                    hashSet.add(mV);
                    if (hashSet.size() > this.start) {
                        list.add(new JQNode(string2, FieldEditor.toJSONString(object), FieldEditor.toJSONString(object2), this.hasChildrenForLayerBuild(calculator, n, map)));
                        ++n4;
                    }
                }
            } else if (++n3 > this.start) {
                list.add(new JQNode(string2, FieldEditor.toJSONString(object), FieldEditor.toJSONString(object2), this.hasChildrenForLayerBuild(calculator, n, map)));
                ++n4;
            }
            ++n2;
        }
    }

    protected boolean hasChildrenForLayerBuild(Calculator calculator, int n, Map map) {
        if (this.isPerformanceFirst()) {
            return this.treeNodeAttr.length != n + 1;
        }
        if (this.treeNodeAttr.length == n + 1) {
            return false;
        }
        TreeLayerNameSpace treeLayerNameSpace = new TreeLayerNameSpace(map);
        calculator.pushNameSpace(treeLayerNameSpace);
        TreeNodeAttr treeNodeAttr = this.getTreeNodeAttr()[n + 1];
        try {
            treeNodeAttr.getDictionary().reset();
            Iterator iterator = treeNodeAttr.getDictionary().entrys(calculator);
            if (!iterator.hasNext()) {
                return false;
            }
        }
        catch (Exception exception) {
            calculator.removeNameSpace(treeLayerNameSpace);
        }
        return true;
    }

    public JSONArray loadDirectTreeData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute());
        FieldEditor.DependenceNameSpace dependenceNameSpace = new FieldEditor.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence"));
        calculator.pushNameSpace(parameterMapNameSpace);
        calculator.pushNameSpace(dependenceNameSpace);
        HashMap hashMap = (HashMap)sessionIDInfor.getAttribute("layerMap");
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        List list = this.generatedDirectTreeData(hashMap, calculator, "", null, null);
        calculator.removeNameSpace(dependenceNameSpace);
        calculator.removeNameSpace(parameterMapNameSpace);
        return JQNode.QNode.createTreeNode(list, false);
    }

    private List generatedDirectTreeData(Map map, Calculator calculator, String string, Object object, HttpServletRequest httpServletRequest) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (this.getTreeNodeAttr() != null) {
            this.traversalTreeDataByLayerBuild(map, calculator, "0", 0, arrayList, new HashSet(), string, 0, object, new HashSet());
        } else if (this.getDictionary() != null) {
            this.traversalTreeDataByAutoBuild(calculator, arrayList, string, object);
        }
        if (StringUtils.isNotEmpty(string) && httpServletRequest != null && WebUtils.getDevice(httpServletRequest).isMobile()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                JQNode.QNode qNode = (JQNode.QNode)iterator.next();
                if (qNode.isExpand()) continue;
                iterator.remove();
            }
        }
        return arrayList;
    }

    private List generatedFilterTreeData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        this.initStartLimit(httpServletRequest);
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "dataFilter");
        this.count = 0;
        FieldEditor.DependenceNameSpace dependenceNameSpace = null;
        if ("true".equalsIgnoreCase(WebUtils.getHTTPRequestParameter(httpServletRequest, "reload"))) {
            this.resetAllDictionary();
            dependenceNameSpace = new FieldEditor.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence"));
            calculator.pushNameSpace(dependenceNameSpace);
        }
        Map map = this.initLayerMap(string, sessionIDInfor);
        return this.generatedDirectTreeData(map, calculator, string, null, httpServletRequest);
    }

    protected Map initLayerMap(String string, SessionIDInfor sessionIDInfor) {
        if (StringUtils.isNotEmpty(string)) {
            return new HashMap();
        }
        Map map = (Map)sessionIDInfor.getAttribute("layerMap");
        return map == null ? new HashMap() : map;
    }

    private void resetAllDictionary() {
        if (this.treeNodeAttr == null) {
            return;
        }
        int n = this.treeNodeAttr.length;
        for (int i = 0; i < n; ++i) {
            this.treeNodeAttr[i].getDictionary().reset();
        }
    }

    private void traversalTreeDataByLayerBuild(Map map, Calculator calculator, String string, int n, List list, Set set, String string2, int n2, Object object, HashSet hashSet) throws Exception {
        if (n == this.treeNodeAttr.length) {
            return;
        }
        int n3 = 1;
        Dictionary dictionary = this.treeNodeAttr[n].getDictionary();
        dictionary.reset();
        Iterator iterator = dictionary.entrys(calculator);
        Condition condition = dictionary.getCondition();
        ArrayList arrayList = new ArrayList();
        TreeComboBoxDataFilter.createFilterArrayList(string2, arrayList);
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            if (this.limit != 0 && this.count >= this.limit) {
                return;
            }
            Object object2 = mV.getModel();
            if (hashSet.contains(object2)) continue;
            hashSet.add(object2);
            map.put(Utils.objectToString(new Integer(n + 1)), object2);
            TreeLayerNameSpace treeLayerNameSpace = new TreeLayerNameSpace(map);
            calculator.pushNameSpace(treeLayerNameSpace);
            Object object3 = mV.getView();
            if (condition != null && !condition.eval(object2, calculator)) {
                calculator.removeNameSpace(treeLayerNameSpace);
                continue;
            }
            boolean bl = n >= this.treeNodeAttr.length - 1 || this.skipNode(arrayList, map, calculator, n + 1);
            boolean bl2 = this.isNotSelf(arrayList, Utils.objectToString(object3), Utils.objectToString(object2), n);
            if (bl2 && bl) {
                calculator.removeNameSpace(treeLayerNameSpace);
                continue;
            }
            TreeDataBuilder treeDataBuilder = new TreeDataBuilder(this.count, n2, n, n3, string, object, this.isMultipleSelection(), this.getDelimiter(), object3, object2);
            treeDataBuilder.traversalTreeNode(list, this.isRemoveRepeat(), set, mV, this.start, n >= this.treeNodeAttr.length - 1);
            this.count = treeDataBuilder.count;
            calculator.removeNameSpace(treeLayerNameSpace);
            this.traversalChildLayer(map, calculator, n, list, set, string2, bl2, treeDataBuilder);
            ++n3;
        }
    }

    private void traversalChildLayer(Map map, Calculator calculator, int n, List list, Set set, String string, boolean bl, TreeDataBuilder treeDataBuilder) throws Exception {
        if (treeDataBuilder.isExpand) {
            TreeLayerNameSpace treeLayerNameSpace = new TreeLayerNameSpace(map);
            calculator.pushNameSpace(treeLayerNameSpace);
            this.traversalTreeDataByLayerBuild(map, calculator, treeDataBuilder.id, n + 1, list, set, bl ? string : "", treeDataBuilder.repeatCount, treeDataBuilder.newValue, new HashSet());
            calculator.removeNameSpace(treeLayerNameSpace);
        }
    }

    private boolean isNotSelf(List list, String string, String string2, int n) {
        for (int i = 0; i < list.size(); ++i) {
            String[] stringArray = (String[])list.get(i);
            if (!TreeComboBoxDataFilter.fixFilterValueOrText(stringArray, string2, string, n)) continue;
            return false;
        }
        return true;
    }

    private void traversalTreeDataByAutoBuild(Calculator calculator, List list, String string, Object object) throws Exception {
        String string2;
        int n;
        TableDataDictionary tableDataDictionary = this.getDictionary();
        RecursionDataModel recursionDataModel = this.getDataModel(calculator);
        HashMap<String, JQNode.QNode> hashMap = new HashMap<String, JQNode.QNode>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (n = 0; n < recursionDataModel.getRowCount(); ++n) {
            string2 = Integer.toString(n);
            String string3 = recursionDataModel.getId(n);
            JQNode.QNode qNode = new JQNode.QNode(string3, recursionDataModel.getParentId(n), recursionDataModel.getValueAt(n, tableDataDictionary.getKeyColumnIndex(recursionDataModel)).toString(), recursionDataModel.getValueAt(n, tableDataDictionary.getValueColumnIndex(recursionDataModel)).toString(), this.treeAttr.isMultipleSelection(), 0, false, recursionDataModel.hasChildren(n));
            hashMap.put(string3, qNode);
            hashMap2.put(string2, string3);
        }
        if (this.setNodeExpandForTraversal(hashMap, recursionDataModel, tableDataDictionary, string, object)) {
            for (n = 0; n < recursionDataModel.getRowCount(); ++n) {
                string2 = Integer.toString(n);
                list.add(hashMap.get(hashMap2.get(string2)));
            }
        }
    }

    private boolean setNodeExpandForTraversal(Map map, RecursionDataModel recursionDataModel, TableDataDictionary tableDataDictionary, String string, Object object) {
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        TreeComboBoxDataFilter.createArrayList(object, arrayList, string, arrayList2);
        try {
            for (int i = 0; i < recursionDataModel.getRowCount(); ++i) {
                String string2 = recursionDataModel.getId(i);
                if (string2 == null) continue;
                String string3 = recursionDataModel.getParentId(i);
                String string4 = recursionDataModel.getValueAt(i, tableDataDictionary.getKeyColumnIndex(recursionDataModel)).toString();
                String string5 = recursionDataModel.getValueAt(i, tableDataDictionary.getValueColumnIndex(recursionDataModel)).toString();
                boolean[] blArray = new boolean[]{false, false};
                if (TreeComboBoxDataFilter.indexOfIgnoreCase(string4.toString(), string) || TreeComboBoxDataFilter.indexOfIgnoreCase(string5.toString(), string)) {
                    bl = true;
                }
                TreeComboBoxDataFilter.checkItem(string2, string5, string4, string, arrayList2, object, arrayList, blArray);
                boolean bl2 = blArray[0];
                boolean bl3 = blArray[1];
                bl = bl2 || bl;
                JQNode.QNode qNode = (JQNode.QNode)map.get(string2);
                if (qNode != null && bl2) {
                    qNode.setExpand(true);
                }
                if (!bl3) continue;
                while (bl2 && (qNode = (JQNode.QNode)map.get(string3)) != null && !qNode.isExpand()) {
                    qNode.setExpand(true);
                    string3 = qNode.getParentID();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean skipNode(List list, Map map, Calculator calculator, int n) {
        Dictionary dictionary = this.treeNodeAttr[n].getDictionary();
        dictionary.reset();
        Iterator iterator = dictionary.entrys(calculator);
        Condition condition = dictionary.getCondition();
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            Object object = mV.getModel();
            map.put(Utils.objectToString(new Integer(n + 1)), object);
            TreeLayerNameSpace treeLayerNameSpace = new TreeLayerNameSpace(map);
            calculator.pushNameSpace(treeLayerNameSpace);
            Object object2 = mV.getView();
            try {
                if (condition != null && !condition.eval(object, calculator)) {
                    continue;
                }
            }
            finally {
                calculator.removeNameSpace(treeLayerNameSpace);
                continue;
            }
            if (!this.isNotSelf(list, Utils.objectToString(object2), Utils.objectToString(object), n)) {
                return false;
            }
            TreeLayerNameSpace treeLayerNameSpace2 = new TreeLayerNameSpace(map);
            calculator.pushNameSpace(treeLayerNameSpace2);
            if (n < this.treeNodeAttr.length - 1 && !this.skipNode(list, map, calculator, n + 1)) {
                return false;
            }
            calculator.removeNameSpace(treeLayerNameSpace2);
        }
        return true;
    }

    private boolean indexOfIgnoreCase(String string, String string2) {
        return string.toUpperCase().indexOf(string2.toUpperCase()) > -1;
    }

    @Override
    protected Map getConvertMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("beforeedit", "click");
        hashMap.put("afteredit", "click");
        hashMap.put("stopedit", "click");
        return hashMap;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("TreeAttr")) {
                TreeAttr treeAttr = new TreeAttr();
                treeAttr.readXML(xMLableReader);
                this.setTreeAttr(treeAttr);
            } else if (string.equals("isLayerBuild")) {
                this.isLayerBuild = xMLableReader.getAttrAsBoolean("isLayerBuild", false);
            } else if (string.equals("LayerConfig")) {
                if (this.layerConfigs == null) {
                    this.layerConfigs = new ArrayList<LayerConfig>();
                }
                LayerConfig layerConfig = new LayerConfig();
                xMLableReader.readXMLObject(layerConfig);
                this.layerConfigs.add(layerConfig);
            } else if (string.equals("TreeNodeAttr")) {
                TreeNodeAttr treeNodeAttr = new TreeNodeAttr();
                xMLableReader.readXMLObject(treeNodeAttr);
                this.treeNodeList.add(treeNodeAttr);
                this.setTreeNodeAttr(this.treeNodeList.toArray(new TreeNodeAttr[this.treeNodeList.size()]));
                this.nodeOrDict = this.getTreeNodeAttr();
            } else if (string.equals("isAutoBuild")) {
                this.setAutoBuild(xMLableReader.getAttrAsBoolean("autoBuild", false));
            } else if (string.equals("Dictionary") || string.equals("MVList")) {
                this.dictionary = (TableDataDictionary)DataCoreXmlUtils.readXMLDictionary(xMLableReader);
                this.nodeOrDict = this.dictionary;
            } else if ("widgetValue".equals(string)) {
                this.widgetValue = new WidgetValue();
                xMLableReader.readXMLObject(this.widgetValue);
            } else if ("text".equals(string)) {
                this.widgetValue = new WidgetValue(xMLableReader.getElementValue());
            } else if ("databinding".equals(string)) {
                this.widgetValue = new WidgetValue(DataBinding.String2DataBinding(xMLableReader.getElementValue()));
            } else if (string.equals("isPerformanceFirst")) {
                this.setPerformanceFirst(xMLableReader.getAttrAsBoolean("performanceFirst", false));
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        int n2;
        super.writeXML(xMLPrintWriter);
        if (this.treeAttr != null) {
            this.treeAttr.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("isLayerBuild").attr("isLayerBuild", this.isLayerBuild).end();
        if (this.layerConfigs != null) {
            n2 = this.layerConfigs.size();
            for (n = 0; n < n2; ++n) {
                xMLPrintWriter.startTAG("LayerConfig");
                this.layerConfigs.get(n).writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
        if (this.treeNodeAttr != null) {
            n2 = this.treeNodeAttr.length;
            for (n = 0; n < n2; ++n) {
                xMLPrintWriter.startTAG("TreeNodeAttr");
                this.treeNodeAttr[n].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.startTAG("isAutoBuild").attr("autoBuild", this.isAutoBuild).end();
        xMLPrintWriter.startTAG("isPerformanceFirst").attr("performanceFirst", this.isPerformanceFirst).end();
        if (this.dictionary != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.dictionary, "Dictionary");
        }
        if (this.widgetValue == null) {
            this.widgetValue = new WidgetValue();
        }
        this.widgetValue.writeXML(xMLPrintWriter);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof TreeEditor && super.equals(object) && ComparatorUtils.equals(this.treeAttr, ((TreeEditor)object).treeAttr) && ComparatorUtils.equals(this.treeNodeAttr, ((TreeEditor)object).treeNodeAttr) && this.dependenceMap == ((TreeEditor)object).dependenceMap;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TreeEditor treeEditor = (TreeEditor)super.clone();
        if (this.treeAttr != null) {
            treeEditor.treeAttr = this.treeAttr;
        }
        if (this.treeNodeAttr != null) {
            ArrayList<TreeNodeAttr> arrayList = new ArrayList<TreeNodeAttr>();
            int n = this.treeNodeAttr.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.treeNodeAttr[i]);
            }
            treeEditor.treeNodeAttr = arrayList.toArray(new TreeNodeAttr[arrayList.size()]);
        }
        treeEditor.isAutoBuild = this.isAutoBuild;
        treeEditor.isLayerBuild = this.isLayerBuild;
        treeEditor.layerConfigs = this.layerConfigs;
        return treeEditor;
    }

    public boolean isAutoBuild() {
        return this.isAutoBuild;
    }

    public void setAutoBuild(boolean bl) {
        this.isAutoBuild = bl;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    @Override
    public TableDataDictionary getDictionary() {
        if (this.dictionary != null && this.dictionary instanceof TableDataDictionary) {
            return (TableDataDictionary)this.dictionary;
        }
        return null;
    }

    public Object getNodeOrDict() {
        if (this.getTreeNodeAttr() != null) {
            return new TreeNodeWrapper(this.isPerformanceFirst, this.getTreeNodeAttr());
        }
        if (this.getDictionary() != null) {
            return this.getDictionary();
        }
        if (this.isLayerBuild) {
            LayerConfig[] layerConfigArray = new LayerConfig[this.layerConfigs.size()];
            int n = 0;
            Iterator<LayerConfig> iterator = this.layerConfigs.iterator();
            while (iterator.hasNext()) {
                LayerConfig layerConfig;
                layerConfigArray[n] = layerConfig = iterator.next();
                ++n;
            }
            return new NameObject("Tree Layer Data", layerConfigArray);
        }
        return this.nodeOrDict;
    }

    public void setNodeOrDict(Object object) {
        NameObject nameObject;
        this.nodeOrDict = object;
        if (object instanceof TreeNodeAttr[]) {
            this.treeNodeAttr = (TreeNodeAttr[])object;
            this.dictionary = null;
            this.isLayerBuild = false;
            this.layerConfigs = null;
        } else if (object instanceof TableDataDictionary) {
            this.dictionary = (TableDataDictionary)object;
            this.treeNodeAttr = null;
            this.isLayerBuild = false;
            this.layerConfigs = null;
        } else if (object instanceof TreeNodeWrapper) {
            this.treeNodeAttr = ((TreeNodeWrapper)object).getTreeNodeAttrs();
            this.isPerformanceFirst = ((TreeNodeWrapper)object).isPerformanceFirst();
            this.isLayerBuild = false;
            this.layerConfigs = null;
        } else if (object instanceof NameObject && "Tree Layer Data".equals((nameObject = (NameObject)object).getName())) {
            this.treeNodeAttr = null;
            this.dictionary = null;
            this.isPerformanceFirst = false;
            this.isLayerBuild = true;
            this.layerConfigs = new ArrayList<LayerConfig>();
            this.layerConfigs.addAll(Arrays.asList((LayerConfig[])nameObject.getObject()));
        }
        this.nodeOrDict = object;
    }

    @Override
    public WidgetValue getWidgetValue() {
        return this.widgetValue;
    }

    @Override
    public void setWidgetValue(WidgetValue widgetValue) {
        this.widgetValue = widgetValue;
    }

    @Override
    public int[] getValueType() {
        return new int[]{1, 2, 3};
    }

    @Override
    public Object dealWithPresentableValue(String string) throws Exception {
        if ((this.getTreeAttr().isReturnFullPath() || this.getTreeAttr().isMultipleSelection()) && string != null && string.startsWith("[") && string.endsWith("]")) {
            return this.JSONArray2DToFArray(string);
        }
        return string;
    }

    private FArray JSONArray2DToFArray(String string) throws JSONException {
        JSONArray jSONArray = (JSONArray)JSONUtils.jsonDecode(string);
        if (jSONArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                Object object = jSONArray.get(i);
                if (object instanceof JSONArray) {
                    arrayList.add(new FArray<Object>(JSONUtils.JSONArrayToList((JSONArray)object)));
                    continue;
                }
                arrayList.add(object);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return new FArray(arrayList);
    }

    @Override
    public Object getModuleValue(Object object, Calculator calculator, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) {
        if (StringUtils.isArrayType(object.toString())) {
            try {
                return this.getModuleValueByPath(object, calculator, sessionIDInfor, httpServletRequest);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        if (this.dictionary != null) {
            return this.checkTargetModel(object, calculator, sessionIDInfor, httpServletRequest, this.dictionary);
        }
        if (this.treeNodeAttr != null) {
            int n = this.treeNodeAttr.length;
            for (int i = 0; i < n; ++i) {
                Dictionary dictionary = this.treeNodeAttr[i].getDictionary();
                Object object2 = this.checkTargetModel(object, calculator, sessionIDInfor, httpServletRequest, dictionary);
                if (object2 == null) continue;
                return object2;
            }
        }
        return null;
    }

    private Object getModuleValueByPath(Object object, Calculator calculator, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) throws Exception {
        String[][] stringArray = null;
        if (object != null && StringUtils.isArrayType(object.toString())) {
            stringArray = StringUtils.stringToArray(object.toString());
        }
        if (this.getDictionary() != null) {
            int n;
            TableDataDictionary tableDataDictionary = this.getDictionary();
            RecursionDataModel recursionDataModel = this.getDataModel(calculator);
            int n2 = tableDataDictionary.getKeyColumnIndex(recursionDataModel);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < recursionDataModel.getRowCount(); ++n) {
                arrayList.add(recursionDataModel.getValueAt(n, n2).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (arrayList.containsAll(Arrays.asList(stringArray[n]))) continue;
                object = null;
                break;
            }
            return object;
        }
        if (this.treeNodeAttr != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i];
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (j > 0) {
                        hashMap.put("LAYER" + j, stringArray2[j - 1]);
                    }
                    TreeLayerNameSpace treeLayerNameSpace = new TreeLayerNameSpace(hashMap);
                    calculator.pushNameSpace(treeLayerNameSpace);
                    if (this.treeNodeAttr.length <= j) {
                        calculator.removeNameSpace(treeLayerNameSpace);
                        return null;
                    }
                    Object object2 = this.checkTargetModel(stringArray2[j], calculator, sessionIDInfor, httpServletRequest, this.treeNodeAttr[j].getDictionary());
                    if (object2 == null) {
                        calculator.removeNameSpace(treeLayerNameSpace);
                        return null;
                    }
                    calculator.removeNameSpace(treeLayerNameSpace);
                }
            }
            return object;
        }
        return null;
    }

    private static class TreeDataBuilder {
        private int count;
        private int repeatCount;
        private boolean isMultipleSelction;
        private Object text;
        private Object value;
        private String parentId;
        private String id;
        private boolean isExpand;
        private Object newValue;

        public TreeDataBuilder(int n, int n2, int n3, int n4, String string, Object object, boolean bl, String string2, Object object2, Object object3) {
            this.repeatCount = n2;
            this.count = n;
            this.isMultipleSelction = bl;
            this.text = object2;
            this.value = object3;
            this.parentId = string;
            this.buildTreeDataByDefaultValue(object, n3, n4, string2);
        }

        private void buildTreeDataByDefaultValue(Object object, int n, int n2, String string) {
            this.id = n == 0 ? Utils.objectToString(new Integer(n2)) : this.parentId + "-" + n2;
            this.isExpand = true;
            this.newValue = null;
            if (object != null) {
                Object[] objectArray = object instanceof Object[] ? (Object[])object : (object instanceof FArray ? ((FArray)object).asObjects() : object.toString().split(string));
                this.setNodeExpandForBuild(objectArray, n);
            }
        }

        private void setNodeExpandForBuild(Object[] objectArray, int n) {
            if (this.isMultipleSelction) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                this.isExpand = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    String[] stringArray;
                    if (objectArray[i] instanceof JSONArray) {
                        stringArray = (String[])objectArray[i];
                        if (stringArray.length() <= n) {
                            this.isExpand = true;
                            continue;
                        }
                        try {
                            if (!ComparatorUtils.equals(stringArray.get(n), this.value) && !ComparatorUtils.equals(stringArray.get(n), this.text)) continue;
                            arrayList.add(stringArray);
                            this.isExpand = true;
                        }
                        catch (JSONException jSONException) {
                            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                        }
                        continue;
                    }
                    stringArray = objectArray[i].toString().split(",");
                    if (stringArray.length <= n) {
                        this.isExpand = true;
                        continue;
                    }
                    if (!ComparatorUtils.equals((Object)stringArray[n], this.value) && !ComparatorUtils.equals((Object)stringArray[n], this.text)) continue;
                    arrayList.add(StringUtils.join(",", stringArray));
                    this.isExpand = true;
                }
                this.newValue = arrayList.isEmpty() ? null : arrayList.toArray();
            } else {
                this.newValue = objectArray;
                this.isExpand = this.needToSetExpand(objectArray, n);
            }
        }

        private boolean needToSetExpand(Object[] objectArray, int n) {
            return objectArray.length > n && (ComparatorUtils.equals(objectArray[n], this.value) || ComparatorUtils.equals(objectArray[n], this.text));
        }

        private void traversalTreeNode(List list, boolean bl, Set set, Dictionary.MV mV, int n, boolean bl2) throws Exception {
            if (bl) {
                if (!set.contains(new JQNode.Node(this.parentId, mV))) {
                    set.add(new JQNode.Node(this.parentId, mV));
                    if (set.size() > n) {
                        list.add(new JQNode.QNode(this.id, this.parentId, FieldEditor.toJSONString(this.value), FieldEditor.toJSONString(this.text), this.isMultipleSelction, 0, this.isExpand, !bl2));
                        ++this.count;
                    }
                } else {
                    this.isExpand = false;
                }
            } else if (++this.repeatCount > n) {
                list.add(new JQNode.QNode(this.id, this.parentId, FieldEditor.toJSONString(this.value), FieldEditor.toJSONString(this.text), this.isMultipleSelction, 0, this.isExpand, !bl2));
                ++this.count;
            }
        }
    }
}

