/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.BaseScriptUtils;
import com.fr.data.AbstractDict;
import com.fr.data.impl.formuladic.BothDependKey;
import com.fr.data.impl.formuladic.EFDependKey;
import com.fr.data.impl.formuladic.EitherDependKey;
import com.fr.data.impl.formuladic.FormulaValueProducer;
import com.fr.data.impl.formuladic.PFDependKey;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Iterator;
import java.util.List;

public class FormulaDictionary
extends AbstractDict {
    public static final String XML_TAG = "FormulaDict";
    public static final String E_XML_TAG = "EFormulaDict";
    private boolean isPFDynamic = true;
    private boolean isEFDynamic = true;
    private FormulaValueProducer fvp = null;
    private String produceFormula;
    private String excuteFormula;
    private transient List kvs;

    public String getProduceFormula() {
        return this.produceFormula;
    }

    public void setProduceFormula(String string) {
        this.produceFormula = string;
        this.isPFDynamic = this.isDynamicFormula(this.getProduceFormula());
    }

    public String getExcuteFormula() {
        return this.excuteFormula;
    }

    public void setExcuteFormula(String string) {
        this.excuteFormula = string;
        this.isEFDynamic = this.isDynamicFormula(this.getExcuteFormula());
    }

    private boolean isDynamicFormula(String string) {
        if (string == null) {
            return true;
        }
        String[] stringArray = new String[]{};
        if (StableUtils.canBeFormula(string)) {
            stringArray = BaseScriptUtils.getDependenceByFormula(string.substring(1));
        }
        return stringArray.length > 0;
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        String[] stringArray = new String[]{};
        if (StableUtils.canBeFormula(this.excuteFormula)) {
            stringArray = BaseScriptUtils.getDependenceByFormula(this.excuteFormula.substring(1));
        }
        String[] stringArray2 = new String[]{};
        if (StableUtils.canBeFormula(this.produceFormula)) {
            stringArray2 = BaseScriptUtils.getDependenceByFormula(this.produceFormula.substring(1));
        }
        String[] stringArray3 = ArrayUtils.addAll(stringArray, stringArray2);
        return ArrayUtils.addAll(super.dependence(calculatorProvider), stringArray3);
    }

    public Iterator entrys(Calculator calculator) {
        if (calculator != null || this.kvs == null) {
            this.createKVS(calculator);
        }
        return new EntryIterator();
    }

    public Iterator entrys(Calculator calculator, int n, int n2) {
        return this.entrys(calculator);
    }

    private void initFvp(Calculator calculator) {
        if (this.isPFDynamic) {
            this.fvp = this.isEFDynamic ? new BothDependKey(this.excuteFormula, this.produceFormula, calculator) : new PFDependKey(this.excuteFormula, this.produceFormula, calculator);
        } else if (this.isEFDynamic) {
            if (this.fvp == null) {
                this.fvp = new EFDependKey(this.excuteFormula, this.produceFormula, calculator);
            }
        } else if (this.fvp == null) {
            this.fvp = new EitherDependKey(this.excuteFormula, this.produceFormula, calculator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object, Calculator calculator) {
        FormulaDictionary formulaDictionary = this;
        synchronized (formulaDictionary) {
            this.initFvp(calculator);
            return this.fvp.getValue(object);
        }
    }

    public void reset() {
        this.kvs = null;
    }

    private void createKVS(Calculator calculator) {
        this.initFvp(calculator);
        this.kvs = this.fvp.getKVS();
    }

    private List keyProduce(Calculator calculator) {
        if (calculator == null) {
            calculator = Calculator.createCalculator();
        }
        FArray<Object> fArray = null;
        Object object = null;
        try {
            if (StringUtils.isNotEmpty(this.produceFormula)) {
                object = calculator.evalValue(this.produceFormula);
            }
        }
        catch (UtilEvalError utilEvalError) {
            FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
        }
        fArray = object instanceof FArray ? (FArray<Object>)object : new FArray<Object>(new Object[]{object});
        return fArray.toList();
    }

    private Object valueProduce(Object object, Calculator calculator) {
        Object object2 = object;
        try {
            if (StringUtils.isNotEmpty(this.excuteFormula)) {
                object2 = calculator.evalValue(this.excuteFormula);
            }
        }
        catch (UtilEvalError utilEvalError) {
            FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
        }
        return object2;
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        exTool.setCreateRelation(true);
        if (StringUtils.isNotEmpty(this.produceFormula)) {
            calculatorProvider.exStatement(columnRow, this.getPureFormulaContent(this.produceFormula));
        }
        if (StringUtils.isNotEmpty(this.excuteFormula)) {
            calculatorProvider.exStatement(columnRow, this.getPureFormulaContent(this.excuteFormula));
        }
        exTool.setCreateRelation(false);
    }

    private String getPureFormulaContent(String string) {
        return string.startsWith("=") ? string.substring(1) : string;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (XML_TAG.equals(xMLableReader.getTagName())) {
                this.setProduceFormula(xMLableReader.getElementValue());
            } else if (E_XML_TAG.equals(xMLableReader.getTagName())) {
                this.setExcuteFormula(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotEmpty(this.produceFormula)) {
            xMLPrintWriter.startTAG(XML_TAG).textNode(this.produceFormula).end();
        }
        if (StringUtils.isNotEmpty(this.excuteFormula)) {
            xMLPrintWriter.startTAG(E_XML_TAG).textNode(this.excuteFormula).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof FormulaDictionary && ComparatorUtils.equals(((FormulaDictionary)object).excuteFormula, this.excuteFormula) && ComparatorUtils.equals(((FormulaDictionary)object).produceFormula, this.produceFormula);
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < FormulaDictionary.this.kvs.size();
        }

        public Object next() {
            Object e = FormulaDictionary.this.kvs.get(this.next);
            ++this.next;
            return e;
        }

        public void remove() {
        }
    }
}

