/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.base.TemplateUtils;
import com.fr.data.DefaultPrintWriterProcessor;
import com.fr.data.DefaultRequestParameterHandler;
import com.fr.general.GeneralUtils;
import com.fr.general.ManagerFactory;
import com.fr.stable.CodeUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.PrintWriterProcessor;
import com.fr.stable.fun.RequestParameterHandler;
import com.fr.stable.fun.ServletURLTransformer;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetworkHelper {
    public static String createServletURL(HttpServletRequest httpServletRequest) {
        ServletURLTransformer servletURLTransformer;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(httpServletRequest.getContextPath());
        stringBuilder.append('/').append(ManagerFactory.getConfigProvider().getServletMapping());
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null && (servletURLTransformer = (ServletURLTransformer)extraClassManagerProvider.getSingle("ServletURLTransformer")) != null) {
            return servletURLTransformer.transform(httpServletRequest, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static InputStream getRequestInputStream(HttpServletRequest httpServletRequest) {
        byte[] byArray = (byte[])httpServletRequest.getAttribute("__inputstream__");
        return new ByteArrayInputStream(byArray);
    }

    public static String getHTTPRequestParameter(HttpServletRequest httpServletRequest, String string) {
        return NetworkHelper.getHTTPRequestEncodeParameter(httpServletRequest, string, true);
    }

    public static String getHTTPRequestParameter(HttpServletRequest httpServletRequest, String ... stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = NetworkHelper.getHTTPRequestParameter(httpServletRequest, stringArray[i]);
                if (string == null) continue;
                return string;
            }
        }
        return "";
    }

    public static boolean getHTTPRequestBoolParameter(HttpServletRequest httpServletRequest, String string) {
        return Boolean.valueOf(NetworkHelper.getHTTPRequestParameter(httpServletRequest, string));
    }

    public static int getHTTPRequestIntParameter(HttpServletRequest httpServletRequest, String string) {
        return NetworkHelper.getHTTPRequestIntParameter(httpServletRequest, string, -1);
    }

    public static int getHTTPRequestIntParameter(HttpServletRequest httpServletRequest, String string, int n) {
        String string2 = NetworkHelper.getHTTPRequestParameter(httpServletRequest, string);
        Number number = GeneralUtils.string2Number(string2);
        if (number == null) {
            return n;
        }
        return number.intValue();
    }

    public static String getHTTPRequestSessionIDParameter(HttpServletRequest httpServletRequest) {
        return NetworkHelper.getHTTPRequestParameter(httpServletRequest, "sessionID");
    }

    public static String getHTTPRequestFileNameParameter(HttpServletRequest httpServletRequest) {
        return NetworkHelper.getHTTPRequestParameter(httpServletRequest, "__filename__");
    }

    public static String getHTTPRequestEncodeParameter(HttpServletRequest httpServletRequest, String string, boolean bl) {
        Object object;
        RequestParameterHandler requestParameterHandler = (RequestParameterHandler)StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class).getSingle("RequestParameterHandler");
        if (requestParameterHandler == null) {
            requestParameterHandler = DefaultRequestParameterHandler.getInstance();
        }
        if ((object = requestParameterHandler.getParameterFromRequest(httpServletRequest, string)) == null) {
            object = requestParameterHandler.getParameterFromAttribute(httpServletRequest, string);
        }
        if (object == null) {
            object = requestParameterHandler.getParameterFromJSONParameters(httpServletRequest, string);
        }
        if (object == null) {
            object = requestParameterHandler.getParameterFromSession(httpServletRequest, string);
        }
        if (object == null && (object = requestParameterHandler.getParameterFromRequest(httpServletRequest, string = CodeUtils.cjkEncode(string))) == null && (object = requestParameterHandler.getParameterFromAttribute(httpServletRequest, string)) == null) {
            object = requestParameterHandler.getParameterFromSession(httpServletRequest, string);
        }
        if (object == null) {
            object = requestParameterHandler.getParameterFromRequestInputStream(httpServletRequest, string);
        }
        return bl ? NetworkHelper.checkURLDecode(object) : GeneralUtils.objectToString(object);
    }

    private static String checkURLDecode(Object object) {
        if (object == null) {
            return null;
        }
        String string = CodeUtils.decodeText(String.valueOf(object));
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string;
        }
    }

    public static String getOriginalURL(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return "";
        }
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        Map map = httpServletRequest.getParameterMap();
        Iterator iterator = map.entrySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (bl) {
                stringBuffer.append('?');
                bl = false;
            } else {
                stringBuffer.append('&');
            }
            stringBuffer.append(entry.getKey().toString());
            stringBuffer.append('=');
            stringBuffer.append(NetworkHelper.getHTTPRequestParameter(httpServletRequest, entry.getKey().toString()));
        }
        return CodeUtils.cjkEncode(stringBuffer.toString());
    }

    public static void writeOutTemplate(String string, HttpServletResponse httpServletResponse, Map map) throws IOException {
        PrintWriter printWriter = NetworkHelper.createPrintWriter(httpServletResponse);
        TemplateUtils.dealWithTemplate(string, printWriter, map);
        printWriter.flush();
        printWriter.close();
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse) throws IOException {
        return NetworkHelper.createPrintWriter(httpServletResponse, ManagerFactory.getConfigProvider().getServerCharset());
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse, String string) throws IOException {
        PrintWriterProcessor printWriterProcessor = null;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null) {
            printWriterProcessor = (PrintWriterProcessor)extraClassManagerProvider.getSingle("PrintWriterProcessor");
        }
        if (printWriterProcessor == null) {
            printWriterProcessor = DefaultPrintWriterProcessor.getInstance();
        }
        return printWriterProcessor.createPrintWriter(httpServletResponse, string);
    }

    public static void setCacheSettings(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-Control", "public");
        httpServletResponse.setHeader("Cache-Control", "max-age=3");
        httpServletResponse.reset();
    }
}

