/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.RPCUtil;
import com.fr.general.FRLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;

class SocketClient {
    private Socket socket;
    private Serializable[] params = new Serializable[0];
    private String ClassName;
    private String MethodName;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;

    public SocketClient(String string, String string2, String string3, int n) {
        if (string3 == null) {
            throw new RuntimeException("invalid socket path");
        }
        this.ClassName = string;
        this.setMethodName(string2);
        try {
            this.socket = new Socket(string3, n);
            this.socket.setSoTimeout(0);
            this.socket.setTrafficClass(28);
        }
        catch (UnknownHostException unknownHostException) {
            FRLogger.getLogger().error(unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
        }
    }

    public void setParams(Serializable[] serializableArray) {
        serializableArray = serializableArray == null ? new Serializable[]{} : serializableArray;
        this.params = serializableArray;
    }

    public void setMethodName(String string) {
        this.MethodName = string;
    }

    public void writeObject() throws IOException {
        if (this.oos == null) {
            this.oos = new ObjectOutputStream(this.socket.getOutputStream());
        }
        this.sendObject((Serializable)((Object)this.ClassName));
        this.sendObject((Serializable)((Object)this.MethodName));
        this.sendObject((Serializable)this.params);
    }

    public Object getReturnObject() {
        return this.getReturnObject(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReturnObject(boolean bl) {
        try {
            Object object;
            if (this.ois == null) {
                this.ois = new ObjectInputStream(this.socket.getInputStream());
            }
            if ((object = this.ois.readObject()) instanceof String && RPCUtil.equalsTool((String)object, "object_null")) {
                Object var3_7 = null;
                return var3_7;
            }
            Object object2 = object;
            return object2;
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRLogger.getLogger().error(classNotFoundException.getMessage());
        }
        finally {
            if (bl) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    FRLogger.getLogger().error(iOException.getMessage());
                }
            }
        }
        return null;
    }

    public void addParam(Serializable serializable) {
        int n = this.params.length;
        Serializable[] serializableArray = new Serializable[n + 1];
        System.arraycopy(this.params, 0, serializableArray, 0, n);
        serializableArray[n] = serializable;
        this.params = serializableArray;
    }

    private void sendObject(Serializable serializable) throws IOException {
        this.oos.writeObject(serializable);
        this.oos.flush();
    }

    private void sendByte(byte by) throws IOException {
        this.oos.writeByte(by);
        this.oos.flush();
    }

    public void close() throws IOException {
        if (this.oos != null) {
            this.oos.close();
            this.oos = null;
        }
        if (this.ois != null) {
            this.ois.close();
            this.ois = null;
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

