/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.concurrentlinkedhashmap;

import com.fr.cache.concurrentlinkedhashmap.Linked;
import com.fr.cache.concurrentlinkedhashmap.NotThreadSafe;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
final class LinkedDeque<E extends Linked<E>>
extends AbstractCollection<E> {
    E first;
    E last;
    int size;

    LinkedDeque() {
    }

    void linkFirst(E e) {
        E e2 = this.first;
        this.first = e;
        if (e2 == null) {
            this.last = e;
        } else {
            e2.setPrevious(e);
            e.setNext(e2);
        }
    }

    void linkLast(E e) {
        E e2 = this.last;
        this.last = e;
        if (e2 == null) {
            this.first = e;
        } else {
            e2.setNext(e);
            e.setPrevious(e2);
        }
    }

    E unlinkFirst() {
        E e = this.first;
        Object object = e.getNext();
        e.setNext(null);
        this.first = object;
        if (object == null) {
            this.last = null;
        } else {
            object.setPrevious(null);
        }
        return e;
    }

    E unlinkLast() {
        E e = this.last;
        Object object = e.getPrevious();
        e.setPrevious(null);
        this.last = object;
        if (object == null) {
            this.first = null;
        } else {
            object.setNext(null);
        }
        return e;
    }

    void unlink(E e) {
        Object t = e.getPrevious();
        Object t2 = e.getNext();
        if (t == null) {
            this.first = t2;
        } else {
            t.setNext(t2);
            e.setPrevious(null);
        }
        if (t2 == null) {
            this.last = t;
        } else {
            t2.setPrevious(t);
            e.setNext(null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    void checkNotEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Object object = this.first;
        while (object != null) {
            Object t = object.getNext();
            object.setPrevious(null);
            object.setNext(null);
            object = t;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Linked)) {
            return false;
        }
        Linked linked = (Linked)object;
        return linked.getPrevious() != null || linked.getNext() != null || linked == this.first;
    }

    public void moveToFront(E e) {
        if (e != this.first) {
            this.unlink(e);
            this.linkFirst(e);
        }
    }

    public void moveToBack(E e) {
        if (e != this.last) {
            this.unlink(e);
            this.linkLast(e);
        }
    }

    public E peek() {
        return this.peekFirst();
    }

    public E peekFirst() {
        return this.first;
    }

    public E peekLast() {
        return this.last;
    }

    public E getFirst() {
        this.checkNotEmpty();
        return this.peekFirst();
    }

    public E getLast() {
        this.checkNotEmpty();
        return this.peekLast();
    }

    public E element() {
        return this.getFirst();
    }

    public boolean offer(E e) {
        return this.offerLast(e);
    }

    public boolean offerFirst(E e) {
        if (this.contains(e)) {
            return false;
        }
        ++this.size;
        this.linkFirst(e);
        return true;
    }

    public boolean offerLast(E e) {
        if (this.contains(e)) {
            return false;
        }
        ++this.size;
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean add(E e) {
        return this.offerLast(e);
    }

    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalArgumentException();
        }
    }

    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalArgumentException();
        }
    }

    public E poll() {
        return this.pollFirst();
    }

    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        --this.size;
        return this.unlinkFirst();
    }

    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        --this.size;
        return this.unlinkLast();
    }

    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        if (this.contains(object)) {
            --this.size;
            this.unlink((Linked)object);
            return true;
        }
        return false;
    }

    public E removeFirst() {
        this.checkNotEmpty();
        return this.pollFirst();
    }

    public boolean removeFirstOccurrence(Object object) {
        return this.remove(object);
    }

    public E removeLast() {
        this.checkNotEmpty();
        return this.pollLast();
    }

    public boolean removeLastOccurrence(Object object) {
        return this.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    public void push(E e) {
        this.addFirst(e);
    }

    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> iterator() {
        return new AbstractLinkedIterator((Linked)this.first){

            @Override
            E computeNext() {
                return this.cursor.getNext();
            }
        };
    }

    public Iterator<E> descendingIterator() {
        return new AbstractLinkedIterator((Linked)this.last){

            @Override
            E computeNext() {
                return this.cursor.getPrevious();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractLinkedIterator
    implements Iterator<E> {
        E cursor;
        final /* synthetic */ LinkedDeque this$0;

        AbstractLinkedIterator(E e) {
            this.this$0 = var1_1;
            this.cursor = e;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object e = this.cursor;
            this.cursor = this.computeNext();
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        abstract E computeNext();
    }
}

