/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.stable.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class CoreDecimalFormat
extends DecimalFormat {
    private DecimalFormat format;
    private String pattern;
    private transient String[] formatArr;
    private transient boolean useSelfFormat = false;

    public CoreDecimalFormat() {
        this.format = new DecimalFormat();
    }

    public CoreDecimalFormat(DecimalFormat decimalFormat, String string) {
        this.format = decimalFormat;
        this.pattern = string;
        this.initFormatArr();
    }

    private void initFormatArr() {
        if (!StringUtils.isEmpty(this.pattern)) {
            boolean bl = this.useSelfFormat = this.format instanceof DecimalFormat && this.pattern.indexOf("%") == -1 && this.pattern.indexOf("E") == -1 && this.pattern.indexOf("\u00a4") == -1;
            if (this.useSelfFormat) {
                this.formatArr = this.pattern.split("\\.");
            }
        }
    }

    public String toPattern() {
        return this.pattern;
    }

    public void applyPattern(String string) {
        if (this.format == null) {
            this.format = new DecimalFormat(string);
        }
        this.format.applyPattern(string);
        this.pattern = string;
        this.initFormatArr();
    }

    public String formatRoundingModeUp(Object object) {
        return this.formatNumberInJDK1_4(object);
    }

    private String formatNumberInJDK1_4(Object object) {
        if (StringUtils.isEmpty(this.pattern)) {
            return GeneralUtils.objectToString(object);
        }
        if (this.useSelfFormat) {
            BigDecimal bigDecimal = null;
            if (this.formatArr.length > 1) {
                int n = this.formatArr[1].length();
                bigDecimal = new BigDecimal(GeneralUtils.objectToString(object)).setScale(n, 4);
            } else if (this.formatArr.length == 1) {
                bigDecimal = new BigDecimal(GeneralUtils.objectToString(object)).setScale(0, 4);
            }
            return this.format.format(bigDecimal);
        }
        return this.format.format(object);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format.format(d, stringBuffer, fieldPosition);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format.format(l, stringBuffer, fieldPosition);
    }

    public boolean equals(Object object) {
        return object instanceof CoreDecimalFormat && ComparatorUtils.equals(((CoreDecimalFormat)object).pattern, this.pattern);
    }

    public int hashCode() {
        return this.format.hashCode();
    }
}

