/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.activiti.engine.impl.jobexecutor.ExecuteJobsRunnable;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobExecutor
extends JobExecutor {
    private static Logger log = LoggerFactory.getLogger(DefaultJobExecutor.class);
    protected int queueSize = 3;
    protected int corePoolSize = 3;
    protected int maxPoolSize = 10;
    protected long keepAliveTime = 0L;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ThreadPoolExecutor threadPoolExecutor;

    @Override
    protected void startExecutingJobs() {
        if (this.threadPoolQueue == null) {
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.threadPoolExecutor == null) {
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, this.threadPoolQueue);
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        }
        this.startJobAcquisitionThread();
    }

    @Override
    protected void stopExecutingJobs() {
        this.stopJobAcquisitionThread();
        this.threadPoolExecutor.shutdown();
        try {
            if (!this.threadPoolExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.warn("Timeout during shutdown of job executor. The current running jobs could not end within 60 seconds after shutdown operation.");
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while shutting down the job executor. ", (Throwable)e);
        }
        this.threadPoolExecutor = null;
    }

    @Override
    public void executeJobs(List<String> jobIds) {
        try {
            this.threadPoolExecutor.execute(new ExecuteJobsRunnable((JobExecutor)this, jobIds));
        }
        catch (RejectedExecutionException e) {
            this.rejectedJobsHandler.jobsRejected(this, jobIds);
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }
}

