package com.jshx.zzhxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmfshxxDao;
import com.jshx.zzhxm.entity.Zzhxmfshxx;
import com.jshx.zzhxm.service.ZzhxmfshxxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhxmfshxxService")
public class ZzhxmfshxxServiceImpl extends BaseServiceImpl implements ZzhxmfshxxService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhxmfshxxDao")
	private ZzhxmfshxxDao zzhxmfshxxDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhxmfshxxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhxmfshxx getById(String id)
	{
		return zzhxmfshxxDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhxmfshxx 信息
	 */
	@Transactional
	public void save(Zzhxmfshxx zzhxmfshxx)
	{
		zzhxmfshxxDao.save(zzhxmfshxx);
	}

	/**
	 * 修改信息
	 * @param zzhxmfshxx 信息
	 */
	@Transactional
	public void update(Zzhxmfshxx zzhxmfshxx)
	{
		zzhxmfshxxDao.update(zzhxmfshxx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhxmfshxxDao.findZzhxmfshxx(paraMap);

		zzhxmfshxxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhxmfshxxDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zzhxmfshxx> findZzhxmfshxx(Map<String, Object> paraMap) {

		return zzhxmfshxxDao.findZzhxmfshxx(paraMap);

	}

	@Override
	public Zzhxmfshxx getByYbjksbh(String ybjksbh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("ybjksbh",ybjksbh);
		Zzhxmfshxx zzhxmfshxx = (Zzhxmfshxx)zzhxmfshxxDao.findObjectByFieldsMap(Zzhxmfshxx.class,paramMap);
		return zzhxmfshxx;
	}

	@Override
	public Zzhxmfshxx getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		Zzhxmfshxx zzhxmfshxx = (Zzhxmfshxx)zzhxmfshxxDao.findObjectByFieldsMap(Zzhxmfshxx.class,paramMap);
		return zzhxmfshxx;
	}
}
