package com.jshx.zzhxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmEntityHistoryDao;
import com.jshx.zzhxm.entity.Zzhxm;
import com.jshx.zzhxm.entity.ZzhxmEntityHistory;
import com.jshx.zzhxm.service.ZzhxmEntityHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhxmEntityHistoryService")
public class ZzhxmEntityHistoryServiceImpl extends BaseServiceImpl implements ZzhxmEntityHistoryService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhxmEntityHistoryDao")
	private ZzhxmEntityHistoryDao zzhxmDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhxmDao.findByPage(page, paraMap);
	}

	@Override
	public Pagination findByPageReview(Pagination page, Map<String, Object> paraMap) {
		return zzhxmDao.findByPageReview(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmEntityHistory getById(String id)
	{
		return zzhxmDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhxm 信息
	 */
	@Transactional
	public void save(ZzhxmEntityHistory zzhxm)
	{
		zzhxmDao.save(zzhxm);
	}

	/**
	 * 修改信息
	 * @param zzhxm 信息
	 */
	@Transactional
	public void update(ZzhxmEntityHistory zzhxm)
	{
		zzhxmDao.update(zzhxm);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = zzhxmDao.findZzhxm(paraMap);

		zzhxmDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhxmDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<ZzhxmEntityHistory> findZzhxm(Map<String, Object> paraMap) {

		return zzhxmDao.findZzhxm(paraMap);

	}

	@Override
	public ZzhxmEntityHistory getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		ZzhxmEntityHistory zzhxm = (ZzhxmEntityHistory) zzhxmDao.findObjectByFieldsMap(Zzhxm.class,paramMap);
		return zzhxm;
	}

	@Override
	public ZzhxmEntityHistory getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		ZzhxmEntityHistory zzhxm = (ZzhxmEntityHistory) zzhxmDao.findObjectByFieldsMap(Zzhxm.class,paramMap);
		return zzhxm;
	}
}
