package com.jshx.zzhqftk.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhqftk.entity.Zzhqftk;
import com.jshx.zzhqftk.service.ZzhqftkService;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZzhqftkAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String autoVal;
	private String autoName;

	/**
	 * 实体类
	 */
	private Zzhqftk zzhqftk = new Zzhqftk();
	private ZzhxmJktzs zzhxmJktzs = new ZzhxmJktzs();

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhqftkService zzhqftkService;
	@Autowired
	private ZzhxmJktzsService zzhxmJktzsService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != zzhqftk){

		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != zzhqftk.getJfdmwybh()) && (0 < zzhqftk.getJfdmwybh().trim().length())){
				paraMap.put("jfdmwybh", "%" + zzhqftk.getJfdmwybh().trim() + "%");
			}
			if ((null != zzhqftk.getAccountDetail()) && (0 < zzhqftk.getAccountDetail().trim().length())){
				paraMap.put("accountDetail", "%" + zzhqftk.getAccountDetail().trim() + "%");
			}
			if ((null != zzhqftk.getJktzsbh()) && (0 < zzhqftk.getJktzsbh().trim().length())){
				paraMap.put("jktzsbh", "%" + zzhqftk.getJktzsbh().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|jfdmwybh|accountDetail|jktzsbh|tkrmc|dbtkje|qfhtksj|czr|qrdzzt|jfdwmc|jfxmmc|jdrkhh|jkrzh|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = zzhqftkService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 *	根据缴款通知书编号获取缴款信息
	 */
	public void getJktzxx() throws Exception {
		try{
			Map<String,Object> paramMap =  new HashMap<>();
			if("jktzsbh".equals(autoName)){
				paramMap.put("jktzsbh",autoVal);
			}else{
				paramMap.put("accountDetail",autoVal);
			}
			List<ZzhxmJktzs> zzhxmJktzsList =  zzhxmJktzsService.findZzhxmJktzs(paramMap);
			if(CollectionUtils.isNotEmpty(zzhxmJktzsList)){
				ZzhxmJktzs zzhxmJktzs1 = zzhxmJktzsList.get(0);
				if(zzhxmJktzs1 != null){
						this.getResponse().getWriter().println("{\"result\":true,\"jktzsbh\":\""+zzhxmJktzs1.getJktzsbh()+"\",\"jfdmwybh\":\""+zzhxmJktzs1.getJfdmwybh()+"\",\"accountDetail\":\""+zzhxmJktzs1.getAccountDetail()+"\",\"jsdwmc\":\""+zzhxmJktzs1.getJsdwmc()+"\",\"jfxmmc\":\""+zzhxmJktzs1.getGcxmmc()+"\"}");
				}else{
					this.getResponse().getWriter().println("{\"result\":false}");
				}
			}
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}


	/**
	 * 	添加字典信息
	 */
	public String initEditadd() throws Exception{
		view();
		return EDIT;
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != zzhqftk)&&(null != zzhqftk.getId()))
			zzhqftk = zzhqftkService.getById(zzhqftk.getId());
		return VIEW;
	}

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}
		zzhqftk.setCzr(this.getLoginUser().getDisplayName());
		zzhqftk.setDeptId(this.getLoginUserDepartmentId());
		zzhqftk.setDelFlag(0);
//			zzhqftkService.save(zzhqftk);
//			zzhqftkService.update(zzhqftk);

		//获取子账户合计到账总金额
		BigDecimal bval= new BigDecimal(zzhqftk.getDbtkje());
		ZzhxmJktzs zzhxmJktzs1 =  zzhxmJktzsService.getByJktzsbh(zzhqftk.getJktzsbh());
		BigDecimal zzhhjzje= new BigDecimal(zzhxmJktzs1.getZzhhjdzje());
		zzhxmJktzs1.setZzhhjdzje(zzhhjzje.subtract(bval).toString());
//		zzhxmJktzsService.update(zzhxmJktzs1);

		//存一站式机制凭证
		Yzscwjzpz yzscwjzpz = new Yzscwjzpz();
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		DateFormat df1 = DateFormat.getDateInstance();
		yzscwjzpz.setDelFlag(0);
		yzscwjzpz.setZdzt("0");//制单状态
		yzscwjzpz.setIspz("0");//是否生成凭证
		String zysj1 = zzhqftk.getQfhtksj().substring(0,10);
		yzscwjzpz.setZdtrq(java.sql.Date.valueOf(formatter.format(simpleDateFormat.parse(zysj1))));
		yzscwjzpz.setAccountDetail(zzhqftk.getAccountDetail());//子账户
		yzscwjzpz.setJfdmwybh(zzhqftk.getJfdmwybh());//缴费代码唯一编号
		yzscwjzpz.setJzpzje(zzhqftk.getDbtkje());//机制凭证金额
		yzscwjzpz.setJfje(zzhqftk.getDbtkje());//借方金额
		yzscwjzpz.setDfje(zzhqftk.getDbtkje());//贷方金额
		yzscwjzpz.setJzpzlx("资金退费凭证");//机制凭证类型
		//获取缴款通知书信息
		zzhxmJktzs = zzhxmJktzsService.getByJfdmwybh(zzhqftk.getJfdmwybh());
		if(null != zzhxmJktzs){
			yzscwjzpz.setJktzsbh(zzhxmJktzs.getJktzsbh());//缴款通知书编号
			yzscwjzpz.setJfdwmc(zzhxmJktzs.getJsdwmc());//缴款单位名称
		}
		String zysj = zzhqftk.getQfhtksj().substring(0,7);
		String zy = zysj + "退还" + zzhxmJktzs.getJsdwmc()  + "缴费"+ "(" + zzhqftk.getAccountDetail() + ")";
		yzscwjzpz.setZy(zy);

		zzhqftkService.saveTkxx(this.flag,zzhqftk,yzscwjzpz,zzhxmJktzs1);
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (null != zzhqftk)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			zzhqftkService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Zzhqftk getZzhqftk(){
		return this.zzhqftk;
	}

	public void setZzhqftk(Zzhqftk zzhqftk){
		this.zzhqftk = zzhqftk;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getAutoVal() {
		return autoVal;
	}

	public void setAutoVal(String autoVal) {
		this.autoVal = autoVal;
	}

	public String getAutoName() {
		return autoName;
	}

	public void setAutoName(String autoName) {
		this.autoName = autoName;
	}
}
