package com.jshx.yzscw.yzscwfzhskm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwfzhskm.dao.YzscwfzhskmDao;
import com.jshx.yzscw.yzscwfzhskm.entity.Yzscwfzhskm;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("yzscwfzhskmDao")
public class YzscwfzhskmDaoImpl extends BaseDaoImpl implements YzscwfzhskmDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findYzscwfzhskmByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findYzscwfzhskm(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzscwfzhskmByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzscwfzhskm getById(String id)
	{
		return (Yzscwfzhskm)this.getObjectById(Yzscwfzhskm.class, id);
	}

	/**
	 * 保存信息
	 * @param yzscwfzhskm 信息
	 */
	public void save(Yzscwfzhskm yzscwfzhskm)
	{
		yzscwfzhskm.setId(null);
		this.saveOrUpdateObject(yzscwfzhskm);
	}

	/**
	 * 修改信息
	 * @param yzscwfzhskm 信息
	 */
	public void update(Yzscwfzhskm yzscwfzhskm)
	{
		this.saveOrUpdateObject(yzscwfzhskm);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Yzscwfzhskm.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Yzscwfzhskm yzscwfzhskm = (Yzscwfzhskm)this.getObjectById(Yzscwfzhskm.class, id);
		yzscwfzhskm.setDelFlag(1);
		this.saveObject(yzscwfzhskm);
	}

	@Override
	public List<Yzscwfzhskm> findKmListByParentKmdm(Map<String, Object> paraMap) {
		return this.findListByHqlId("findYzscwfzhskmByMap", paraMap);
	}

	@Override
	public Yzscwfzhskm findKmglByKmdm(String s) {
		return (Yzscwfzhskm)this.getObjectByProperty(Yzscwfzhskm.class, "kmdm", s);
	}
}
