package com.jshx.xmdrb.service.impl;

/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2012-2014 Jiangsu Hongxin System Integration Co., Ltd.   */
/*                                                                        */
/* PROPRIETARY RIGHTS of Jiangsu Hongxin are involved in the 　　　　　　 */
/* subject matter of this material.  All manufacturing, reproduction, use,*/
/* and sales rights pertaining to this subject matter are governed by the */
/* license agreement. The recipient of this software implicitly accepts   */
/* the terms of the license.                                              */
/* 本软件文档资料是江苏鸿信公司的资产,任何人士阅读和使用本资料必须获得    */
/* 相应的书面授权,承担保密责任和接受相应的法律约束.                       */
/*                                                                        */
/**************************************************************************/

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang.StringUtils;
import org.openwebflow.util.ProcessDefinitionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmdrb.dao.GenericDao;
import com.jshx.xmdrb.service.GenericManager;;
@Service("genericManager")
public class GenericManagerImpl<T, PK extends Serializable> extends BaseServiceImpl implements GenericManager<T, PK> {
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("genericDao")
	private GenericDao<T, PK> genericDao;

	@Autowired
	private IdentityService identityService;

	@Autowired
	private RuntimeService runtimeService;

	@Autowired
	private TaskService taskService;

	@Autowired
	private HistoryService historyService;

	@Autowired
	private RepositoryService repositoryService;

	@Autowired
	private FormService formService;
	@Autowired
	private ProcessEngine _processEngine;

	public ProcessEngine get_processEngine() {
		return _processEngine;
	}

	public void set_processEngine(ProcessEngine _processEngine) {
		this._processEngine = _processEngine;
	}

	public GenericDao<T, PK> getGenericDao() {
		return genericDao;
	}

	public void setGenericDao(GenericDao<T, PK> genericDao) {
		this.genericDao = genericDao;
	}

	/**
	 * 分页查询
	 * 
	 * @param page
	 *            分页信息
	 * @param paraMap
	 *            查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
		return genericDao.findByPage(page, paraMap);
	}

	@Override
	@Transactional
	public Object findClassById(Class class1, String id) {
		// TODO Auto-generated method stub
		return genericDao.findClassById(class1, id);
	}

	@Override
	@Transactional
	public List<T> findListById(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return genericDao.findListById(paraMap);
	}

	@Override
	@Transactional
	public Object findClassByObject(Class class1, String string, String id) {
		// TODO Auto-generated method stub
		return genericDao.findClassByObject(class1, string, id);
	}

	@Override
	@Transactional
	public List<T> findListBySqlId(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return genericDao.findListBySqlId(paraMap);
	}

	@Override
	public Pagination findBySqlId(Pagination page, Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return genericDao.findBySqlId(page, paraMap);
	}

	@Override
	@Transactional
	public List<T> findListByObject(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return genericDao.findListByObject(paraMap);
	}

	@Override
	@Transactional
	public void update(T obj) {
		// TODO Auto-generated method stub
		genericDao.update(obj);
	}

	@Transactional
	public void saveOrUpdate(T obj) {
		genericDao.saveOrUpdate(obj);
	}

	@Override
	@Transactional
	public void deleteWithFlag(Class class1, String ids) {
		// TODO Auto-generated method stub
		String[] idArray = ids.split("\\|");

		if (null != idArray) {
			StringBuffer hql = new StringBuffer();
			hql.append("update ");
			hql.append(class1.getName().substring(class1.getName().lastIndexOf(".") + 1));
			hql.append(" set delFlag=1 where id in (");
			for (int i = 0; i < idArray.length; i++) {
				hql.append(" '");
				hql.append(idArray[i]);
				hql.append("'");
				if (i < idArray.length - 1)
					hql.append(",");
			}
			hql.append(" )");
			genericDao.deleteWithFlag(hql.toString());
		}
	}

	@Override
	public Object getObjectByProperty(Class entity, String[] name, Object[] value) {
		// TODO Auto-generated method stub
		return genericDao.getObjectByProperty(entity, name, value);
	}

	@Override
	@Transactional
	public void updateByHql(String hql) {
		// TODO Auto-generated method stub
		genericDao.updateByHql(hql);
	}

	@Override
	@Transactional
	public void saveOrUpdateByHql(T obj) {
		// TODO Auto-generated method stub
		genericDao.saveOrUpdateByHql(obj);
	}

	@Override
	@Transactional
	public void updateByHql(Map paraMap) {
		// TODO Auto-generated method stub
		genericDao.updateByHql(paraMap);
	}

	@Override
	@Transactional
	public void updateBySql(Map paraMap) {
		// TODO Auto-generated method stub
		genericDao.updateBySql(paraMap);
	}

	/**
	 * 开启工作流
	 * 
	 * @paramkey:为工作流名称
	 * @paramvariables：里面存入message信息与user列表与业务表主键信息
	 */
	@Override
	@Transactional
	public String startProcessInstance(String key, String row_id, String userId, Map<String, Object> variables) {
		// TODO Auto-generated method stub
		this.identityService.setAuthenticatedUserId(userId);
		ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key, row_id, variables);
		if (processInstance != null) {
			return processInstance.getProcessInstanceId();
		} else {
			return "";
		}
	}

	/**
	 * 找当前节点的候选审批人 供流程实例start后调用
	 * 
	 * @param taskId
	 * @return
	 */
	public List<String> getThisTaskUser(String taskId) {
		List<String> list = new ArrayList<String>();
		taskService.addCandidateUser(taskId, "");

		// list.add(taskUser);
		return list;
	}

	/**
	 * 获取未签收的任务查询对象
	 * 
	 * @param userId
	 *            用户ID
	 */
	@Transactional(readOnly = true)
	public TaskQuery createUnsignedTaskQuery(String userId, String processDefKey) {
		TaskQuery taskCandidateUserQuery = taskService.createTaskQuery().processDefinitionKey(processDefKey)
				.taskCandidateUser(userId).orderByTaskCreateTime().desc();
		return taskCandidateUserQuery;
	}

	/**
	 * 获取正在处理的任务查询对象
	 * 
	 * @param userId
	 *            用户ID
	 */
	@Transactional(readOnly = true)
	public TaskQuery createTodoTaskQuery(String userId, String processDefKey) {
		TaskQuery taskAssigneeQuery = taskService.createTaskQuery().processDefinitionKey(processDefKey)
				.taskAssignee(userId).orderByTaskCreateTime().desc();
		return taskAssigneeQuery;
	}

	/**
	 * 获取未经完成的流程实例查询对象
	 * 
	 * @param userId
	 *            用户ID
	 */
	@Transactional(readOnly = true)
	public ProcessInstanceQuery createUnFinishedProcessInstanceQuery(String processDefKey) {
		ProcessInstanceQuery unfinishedQuery = runtimeService.createProcessInstanceQuery()
				.processDefinitionKey(processDefKey).active().orderByProcessInstanceId().desc();
		return unfinishedQuery;
	}

	/**
	 * 获取已经完成的流程实例查询对象
	 * 
	 * @param userId
	 *            用户ID
	 */
	@Transactional(readOnly = true)
	public HistoricProcessInstanceQuery createFinishedProcessInstanceQuery(String processDefKey) {
		HistoricProcessInstanceQuery finishedQuery = historyService.createHistoricProcessInstanceQuery()
				.processDefinitionKey(processDefKey).finished().orderByProcessInstanceId().desc();
		return finishedQuery;
	}

	@Override
	public List<String> findAllPersons(String staticActiveDefId, String workFlowModelId, String deptCode) {
		// TODO Auto-generated method stub
		List<String> list = new ArrayList<String>();
		Map paraMap = new HashMap();
		paraMap.put("SqlId", "findAllPersons");
		paraMap.put("staticActiveDefId", staticActiveDefId);
		paraMap.put("workFlowModelId", workFlowModelId);
		paraMap.put("deptCode", deptCode + "%");
		list = (List<String>) genericDao.findListByObject(paraMap);
		return list;
	}

	public List<String> findAllPersons(Map<String, Object> variables) {
		// TODO Auto-generated method stub
		List<String> list = new ArrayList<String>();
		Map paraMap = new HashMap();
		paraMap.put("SqlId", "findAllPersons");
		paraMap.put("staticActiveDefId", variables.get("ID"));
		paraMap.put("workFlowModelId", variables.get("key"));
		paraMap.put("deptCode", variables.get("deptCode") + "%");
		list = (List<String>) genericDao.findListByObject(paraMap);
		return list;
	}

	public String findAllPersons1(String staticActiveDefId, String workFlowModelId, String deptCode) {
		// TODO Auto-generated method stub
//		List<String> list = new ArrayList<String>();
//		Map paraMap = new HashMap();
//		paraMap.put("SqlId", "findAllPersons");
//		paraMap.put("staticActiveDefId", staticActiveDefId);
//		paraMap.put("workFlowModelId", workFlowModelId);
//		paraMap.put("deptCode", deptCode + "%");
//		list = (List<String>) genericDao.findListByObject(paraMap);
//		return FileUtils.listToString(list);
		return null;
	}

	public List<Map<String, Object>> getOutGoingTransNames(String taskId) {
		List<Map<String, Object>> transNames = new ArrayList<Map<String, Object>>();
		Map<String, Object> map = null;
		Task task = this.taskService.createTaskQuery().taskId(taskId).singleResult();
		String excId = task.getExecutionId();
		ExecutionEntity execution = (ExecutionEntity) runtimeService.createExecutionQuery().executionId(excId)
				.singleResult();
		String activitiId = execution.getActivityId();

		ProcessDefinitionEntity pd = (ProcessDefinitionEntity) repositoryService
				.getProcessDefinition(task.getProcessDefinitionId());
		// 4.通过活动的ID在流程定义中找到对应的活动对象
		ActivityImpl activity = pd.findActivity(activitiId);
		// 5.通过活动对象找当前活动的所有出口
		List<PvmTransition> transitions = activity.getOutgoingTransitions();
		// 6.提取所有出口的名称，封装成集合
		for (PvmTransition trans : transitions) {
			map = new HashMap<String, Object>();
			String transName = (String) trans.getProperty("name");

			if (StringUtils.isNotBlank(transName)) {
				map.put("transName", transName);
				String str = (String) trans.getProperty("conditionText");
				map.put("id", str.substring(15, str.length() - 2));
				transNames.add(map);
			}
		}
		return transNames;
	}

	@Override
	public void passProcess(String taskId, String comment, Map<String, Object> variables) {
		// 跳转节点为空，默认提交操作
		if (null != comment && !comment.isEmpty())
			taskService.addComment(taskId, null, comment);// comment为批注内容
		taskService.complete(taskId, variables);
	}

	public void createAttachment(String attachmentType, String taskId, String processInstanceId, String attachmentName,
			String url) {
		taskService.createAttachment(attachmentType, taskId, processInstanceId, attachmentName, "", url);
	}

	@Override
	public List<Map<String, Object>> getinstanceDiagram(String processInstanceId) {
		// TODO Auto-generated method stub
		List<HistoricActivityInstance> hais = historyService.createHistoricActivityInstanceQuery()
				// 过滤条件
				.processInstanceId(processInstanceId)
				// 分页条件
				// .listPage(firstResult, maxResults)
				// 排序条件
				.orderByHistoricActivityInstanceStartTime().asc()
				// 执行查询
				.list();

		Map<String, Object> map = null;
		List<Map<String, Object>> hlist = new ArrayList<Map<String, Object>>();
		Date claimTime = null;
		for (HistoricActivityInstance hai : hais) {
			map = new HashMap<String, Object>();

			if (hai.getActivityId().equals("usertask1") || hai.getActivityId().equals("usertask2")) {
				claimTime = null!=((HistoricTaskInstance) this.historyService.createHistoricTaskInstanceQuery()
						.taskId(hai.getTaskId()).singleResult())?((HistoricTaskInstance) this.historyService.createHistoricTaskInstanceQuery()
								.taskId(hai.getTaskId()).singleResult()).getClaimTime():null;
				map = new HashMap<String, Object>();
				map.put("name", "签收");
				map.put("endTime", null == claimTime ? "" : claimTime);
				map.put("assignee", hai.getAssignee());
				hlist.add(map);
			}

			map = new HashMap<String, Object>();
			map.put("name", hai.getActivityName());
			map.put("startTime", hai.getStartTime());
			map.put("endTime", hai.getEndTime());
			map.put("assignee", hai.getAssignee());

			List<Comment> comments = taskService.getTaskComments(hai.getTaskId());
			if (null != comments && comments.size() > 0) {
				map.put("remark", comments.get(0).getFullMessage());
			} else {
				map.put("remark", "");
			}
			List<Attachment> list = taskService.getTaskAttachments(hai.getTaskId());

			map.put("attList", list);

			hlist.add(map);
			if (hai.getActivityId().equals("usertask1") || hai.getActivityId().equals("usertask2")) {
				if (null == claimTime)
					hlist.remove(hlist.size() - 1);
			}
			claimTime = null;
		}
		return hlist;
	}

	@Override
	public String getTaskFormData(String taskId) {
		// TODO Auto-generated method stub
		TaskFormData formData = formService.getTaskFormData(taskId);
		return formData.getFormKey();
	}

	/**
	 * 中止流程(特权人直接审批通过等)
	 * 
	 * @param taskId
	 */
	public void endProcess(String processId) {
		// 获取流程定义的所有节点
		try {
			jump("endevent1", processId);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * 跳转至指定活动节点
	 * 
	 * @param targetTaskDefinitionKey
	 * @throws Exception
	 */
	@Transactional
	public void jump(String targetTaskDefinitionKey, String _processId) throws Exception {
		TaskEntity currentTask = (TaskEntity) _processEngine.getTaskService().createTaskQuery()
				.processInstanceId(_processId).singleResult();
		jump(currentTask, targetTaskDefinitionKey);
		Map paraMap=new HashMap();
		paraMap.put("SqlId", "updateEXECUTION");
		paraMap.put("targetTaskDefinitionKey", _processId);
		paraMap.put("currentTaskEntity", targetTaskDefinitionKey);
		genericDao.updateBySql(paraMap);
	}

	/**
	 * 
	 * @param currentTaskEntity
	 *            当前任务节点
	 * @param targetTaskDefinitionKey
	 *            目标任务节点（在模型定义里面的节点名称）
	 * @throws Exception
	 */
	private void jump(final TaskEntity currentTaskEntity, String targetTaskDefinitionKey) throws Exception {
		final ActivityImpl activity = ProcessDefinitionUtils.getActivity(_processEngine,
				currentTaskEntity.getProcessDefinitionId(), targetTaskDefinitionKey);

		final ExecutionEntity execution = (ExecutionEntity) _processEngine.getRuntimeService().createExecutionQuery()
				.executionId(currentTaskEntity.getExecutionId()).singleResult();

		final TaskService taskService = _processEngine.getTaskService();

		// 包装一个Command对象
		((RuntimeServiceImpl) _processEngine.getRuntimeService()).getCommandExecutor()
				.execute(new Command<java.lang.Void>() {
					@Override
					public Void execute(CommandContext commandContext) {
						// 创建新任务
						execution.setActivity(activity);
						execution.executeActivity(activity);

						// 删除当前的任务
						// 不能删除当前正在执行的任务，所以要先清除掉关联
						currentTaskEntity.setExecutionId(null);
						taskService.saveTask(currentTaskEntity);
						taskService.deleteTask(currentTaskEntity.getId(), true);
						
						return null;
					}
				});
	}

	@Override
	public String getTaskName(String processInstanceId) {
		// TODO Auto-generated method stub
		List<HistoricActivityInstance> hais = historyService.createHistoricActivityInstanceQuery()
				// 过滤条件
				.processInstanceId(processInstanceId)
				// 分页条件
				// .listPage(firstResult, maxResults)
				// 排序条件
				.orderByHistoricActivityInstanceStartTime().desc()
				// 执行查询
				.list();

		if (null != hais && hais.size() > 0) {
			return hais.get(0).getActivityName();
		} else {
			return "";
		}
	}

	@Override
	@Transactional
	public String getSN(String dm) {
		// TODO Auto-generated method stub
		Map paraMap = new HashMap();
		paraMap.put("SqlId", "get"+dm);
		String sn = (String) genericDao.findObjectByCombinedSql(paraMap);
		return sn;
	}
	@Override
	public String getslbh(String dwdm) {
      //受理编号
		Map paraMap = new HashMap();
		paraMap.put("SqlId", "getquanshi");
		String sn = (String) genericDao.findObjectByCombinedSql(paraMap)+dwdm+getSN(dwdm);
		
		return sn;
	}
	
	
	@Override
	@Transactional
	public void remove(T a) {
		// TODO Auto-generated method stub
		genericDao.remove(a);
	}

	@Override
	public List<String> getHighLightedFlows(ProcessDefinitionEntity processDefinitionEntity,
			List<HistoricActivityInstance> historicActivityInstances) {
		List<String> highFlows = new ArrayList<String>();// 用 以保存高亮的线flowId
		for (int i = 0; i < historicActivityInstances.size() - 1; i++) {// 对历史流程节点进行遍历
			ActivityImpl activityImpl = processDefinitionEntity
					.findActivity(historicActivityInstances.get(i).getActivityId());// 得到节点定义的详细
																					// 信息
			List<ActivityImpl> sameStartTimeNodes = new ArrayList<ActivityImpl>();// 用以保存后需开始时间相同的节点
			ActivityImpl sameActivityImpl1 = processDefinitionEntity
					.findActivity(historicActivityInstances.get(i + 1).getActivityId());// 将后面第一个节点放
																						// 在时间相同节点的集合里
			sameStartTimeNodes.add(sameActivityImpl1);
			for (int j = i + 1; j < historicActivityInstances.size() - 1; j++) {
				HistoricActivityInstance activityImpl1 = historicActivityInstances.get(j);// 后续第一个节点
				HistoricActivityInstance activityImpl2 = historicActivityInstances.get(j + 1);// 后续第二个节点
				if (activityImpl1.getStartTime().equals(activityImpl2.getStartTime())) {
					// 如果第 一个节点和第二个节点开始时间相同保存
					ActivityImpl sameActivityImpl2 = processDefinitionEntity
							.findActivity(activityImpl2.getActivityId());
					sameStartTimeNodes.add(sameActivityImpl2);
				} else {// 有不相同跳出循环
					break;
				}
			}
			List<PvmTransition> pvmTransitions = activityImpl.getOutgoingTransitions();// 取出节点的所有出
																						// 去的线
			for (PvmTransition pvmTransition : pvmTransitions) {// 对所有的线进行遍历
				ActivityImpl pvmActivityImpl = (ActivityImpl) pvmTransition.getDestination();// 如果取出的线的目标节点
																								// 存在时间相同的节点里，保存该线的id，进行高亮显示
				if (sameStartTimeNodes.contains(pvmActivityImpl)) {
					highFlows.add(pvmTransition.getId());
				}
			}
		}
		return highFlows;
	}

	@Override
	public List<Map<String, Boolean>> getHighLightedActivities(ProcessDefinitionEntity processDefinition,
			List<HistoricActivityInstance> historicActivityInstances) {
		List<Map<String, Boolean>> highLightedActivities = new ArrayList<Map<String, Boolean>>();
		int activityCount = historicActivityInstances.size();
		Map<String, Boolean> activityMap = new HashMap<String, Boolean>();
		activityMap.put(historicActivityInstances.get(historicActivityInstances.size() - 1).getActivityId(), true);
		highLightedActivities.add(activityMap);
		boolean findCurrActivity = true;
		// 是否查询并发任务节点
		for (int j = activityCount - 2; j >= 0; j--) {
			// 判断 前面节点是否与
			Map<String, Boolean> activityMap2 = new HashMap<String, Boolean>();
			HistoricActivityInstance activityImpl1 = historicActivityInstances.get(j);
			// 前面第一个节点
			if (findCurrActivity) {
				HistoricActivityInstance activityImpl2 = historicActivityInstances.get(j + 1);// 当前节点
				if (activityImpl1.getStartTime().equals(activityImpl2.getStartTime())) {
					String type = activityImpl1.getActivityType();
					// 排除系统自动执行节点
					if ("userTask".equals(type) || "endEvent".equals(type)) {
						activityMap2.put(activityImpl1.getActivityId(), false);
					} else {
						activityMap2.put(activityImpl1.getActivityId(), false);
					}
				} else {
					activityMap2.put(activityImpl1.getActivityId(), false);
					findCurrActivity = false;
				}
				highLightedActivities.add(activityMap2);
			} else {
				activityMap2.put(activityImpl1.getActivityId(), false);
				highLightedActivities.add(activityMap2);
			}
		}
		return highLightedActivities;
	}

	@Override
	public String getDays(String defId2) {
		// TODO Auto-generated method stub
		Map paraMap = new HashMap();
		paraMap.put("SqlId", "getDays");
		paraMap.put("defId", defId2);
		return (String) genericDao.findListByObject(paraMap).get(0);
	}

	@Override
	public String getSN2() {
		// TODO Auto-generated method stub
		Map paraMap = new HashMap();
		paraMap.put("SqlId", "getSN2");
		String sn = (String) genericDao.findObjectByCombinedSql(paraMap);
		return sn;
	}

	@Override
	public int batchInsertZh(List<String[]> list) {
		 String[][] params = new String[list.size()][];
		for (int i = 0; i < list.size(); i++)
        {
            //个人缴存资料字段内容：公积金个人帐户(gjjcx.txt)：
            //个人帐号  姓名   身份证号码         余额    月缴额 帐户状态 缴存截止时间 缴存银行 单位名称
            //GJJCODE,NAME,IDCARD,BALANCE,PAYMENTMONEY,STATUS,PAYMENTDAY,PAYMENTBANK,COMPANY
            if(list.get(i)[0].startsWith("0")){
                String[] temp = new String[] { list.get(i)[0].replaceFirst("0","").trim(), list.get(i)[1].trim(), list.get(i)[2].trim(), list.get(i)[3].trim(),
                        list.get(i)[4].trim(), list.get(i)[5].trim(), list.get(i)[6].trim(), list.get(i)[7].trim(), list.get(i)[8].trim() };
                params[i] = temp;
            }
            else
            {
                String[] temp = new String[] { list.get(i)[0].trim(), list.get(i)[1].trim(), list.get(i)[2].trim(), list.get(i)[3].trim(),
                        list.get(i)[4].trim(), list.get(i)[5].trim(), list.get(i)[6].trim(), list.get(i)[7].trim(), list.get(i)[8].trim() };
                params[i] = temp;
            }
            

           
            
        }   
		PreparedStatement ps = null;
        
          

            int len = params.length;
            for (int i = 0; i < len; i++)
            {
                

                for (int j = 0; j < params[i].length; j++)
                {
                    int position = j + 1;
                    
                        // 所有的参数用setString传值
                        try {
							ps.setString(position, params[i][j]);
						} catch (SQLException e) {
							
						}
                   
            }
            }
		return 0;
	}

	@Override
	public String getSN() {
		Map paraMap = new HashMap();
//		Calendar c = Calendar.getInstance();    
//		  int today = c.get(c.DAY_OF_MONTH);
//		 
		paraMap.put("SqlId", "getSN3");
		String sn = (String) genericDao.findObjectByCombinedSql(paraMap);
		return sn;
		
	}



}