package com.jshx.rfxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwjzpz.dao.YzscwjzpzDao;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhkppj.dao.ZzhkppjDao;
import com.jshx.zzhkppj.entity.Zzhkppj;
import com.jshx.rfxm.dao.RfxmDao;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.service.RfxmService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("rfxmService")
public class RfxmServiceImpl extends BaseServiceImpl implements RfxmService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("rfxmDao")
	private RfxmDao rfxmDao;

	@Autowired()
	@Qualifier("zzhkppjDao")
	private ZzhkppjDao zzhkppjDao;

	@Autowired()
	@Qualifier("yzscwjzpzDao")
	private YzscwjzpzDao yzscwjzpzDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return rfxmDao.findByPage(page, paraMap);
	}

	@Override
	public Pagination findByPageReview(Pagination page, Map<String, Object> paraMap) {
		return rfxmDao.findByPageReview(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Rfxm getById(String id)
	{
		return rfxmDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param rfxm 信息
	 */
	@Transactional
	public void save(Rfxm rfxm)
	{
		rfxmDao.save(rfxm);
	}

	/**
	 * 修改信息
	 * @param rfxm 信息
	 */
	@Transactional
	public void update(Rfxm rfxm)
	{
		rfxmDao.update(rfxm);
	}
	@Transactional
	@Override
	public void updateNotSave(Rfxm rfxm)
	{
		rfxmDao.update(rfxm);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=rfxmDao.findRfxm(paraMap);

		rfxmDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					rfxmDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Rfxm> findRfxm(Map<String, Object> paraMap) {

		return rfxmDao.findRfxm(paraMap);

	}

	@Override
	public Rfxm getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		Rfxm rfxm = (Rfxm)rfxmDao.findObjectByFieldsMap(Rfxm.class,paramMap);
		return rfxm;
	}

	@Override
	public Rfxm getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		Rfxm rfxm = (Rfxm)rfxmDao.findObjectByFieldsMap(Rfxm.class,paramMap);
		return rfxm;
	}

	/**
	 * 保存接口4
	 * @param zzhkppj 信息
	 */
	@Transactional
	public void saveJk4(List<Zzhkppj> zzhkppjList, Zzhkppj zzhkppj){
		if(CollectionUtils.isEmpty(zzhkppjList) || zzhkppjList.size() == 0){
			zzhkppjDao.save(zzhkppj);
		}
	}

	/**
	 * 保存接口6
	 * @param yzscwjzpz 信息
	 */
	@Transactional
	public void saveJk6(Zzhkppj zzhkppj, Yzscwjzpz yzscwjzpz){
		zzhkppjDao.update(zzhkppj);
		yzscwjzpzDao.save(yzscwjzpz);
	}
}
