package com.jshx.rfxm.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.yzscw.yzscwpzgl.entity.Yzscwpzgl;
import com.jshx.zzhkppj.entity.Zzhkppj;
import com.jshx.rfxm.entity.Rfxm;

import java.util.List;
import java.util.Map;

public interface RfxmService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	Pagination findByPageReview(Pagination pagination, Map<String, Object> paraMap);
	public List<Rfxm> findRfxm(Map<String, Object> paraMap);
	public Rfxm getByXmdm(String xmdm);

	public Rfxm getByJfdmwybh(String jfdmwybh);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Rfxm getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Rfxm model);


	/**
	 * 保存接口4
	 * @param model 信息
	 */
	public void saveJk4(List<Zzhkppj> zzhkppjList, Zzhkppj zzhkppj);

	/**
	 * 保存接口6
	 * @param model 信息
	 */
	public void saveJk6(Zzhkppj zzhkppj, Yzscwjzpz yzscwjzpz);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Rfxm model);

	public void updateNotSave(Rfxm model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

}
