package com.jshx.returnItem.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.lxrinfo.entity.Lxrinfo;
import com.jshx.lxrinfo.service.LxrinfoService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.returnItem.entity.ReturnItem;
import com.jshx.returnItem.service.ReturnItemService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;

public class ReturnItemAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private ReturnItem returnItem = new ReturnItem();
	
	private Zsdw zsdwxx = new Zsdw();
	private Lxrinfo lxrinfo=new Lxrinfo();

	/**
	 * 业务类
	 */
	@Autowired
	private ReturnItemService returnItemService;
	
	@Autowired
	private XmxxbService xmxxbService;

	@Autowired
	private ZsdwService zsdwService;
	
	@Autowired
	private FawenAttachService fawenAttachService; 
	
	@Autowired
	private GenericManager genericManager;
	@Autowired
        private LxrinfoService lxrinfoService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	private String No;

	private String currentDate;
	
	private String attachName;
	

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != returnItem){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != returnItem.getJsdw()) && (0 < returnItem.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + returnItem.getJsdw().trim() + "%");
			}

			if ((null != returnItem.getXmmc()) && (0 < returnItem.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + returnItem.getXmmc().trim() + "%");
			}

			if ((null != returnItem.getXmdd()) && (0 < returnItem.getXmdd().trim().length())){
				paraMap.put("xmdd", "%" + returnItem.getXmdd().trim() + "%");
			}

			if ((null != returnItem.getCkbh()) && (0 < returnItem.getCkbh().trim().length())){
				paraMap.put("ckbh", "%" + returnItem.getCkbh().trim() + "%");
			}

			if ((null != returnItem.getSlbh()) && (0 < returnItem.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + returnItem.getSlbh().trim() + "%");
			}

			if ((null != returnItem.getXxylb()) && (0 < returnItem.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + returnItem.getXxylb().trim() + "%");
			}
			
			if ((null != returnItem.getPrintFlag()) && (0 < returnItem.getPrintFlag().trim().length())){
				paraMap.put("printFlag", returnItem.getPrintFlag());
			}
			
			if ((null != returnItem.getReturnStatus()) && (0 < returnItem.getReturnStatus().trim().length())){
				paraMap.put("returnStatus", returnItem.getReturnStatus());
			}
			
			if(!this.getLoginUser().getIsSuperAdmin()){
            	String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
            	paraMap.put("dwdm", dwdm);
            }

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|returnStatus|processInsId|lxdh|jsdw|xmmc|xmdd|ckbh|slbh|xxylb|zjzmj|lxr|bllb|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = returnItemService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		currentDate = outSdf.format(new Date());
		if((null != returnItem)&&(null != returnItem.getId())){
			returnItem = returnItemService.getById(returnItem.getId());
		}
		zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
		lxrinfo=lxrinfoService.getBybhdwdm("004", zsdwxx.getZsdm());
	    Map<String, String> partj = new HashMap<String, String>();
    	partj.put("xmType", "缴费受理");
    	partj.put("bizrowid",returnItem.getXmbzj());
    	List<FawenAttach> attachList= fawenAttachService.queryAttachListByTempleId(partj);
    	StringBuffer buffer = new StringBuffer();
    	if(null != attachList && attachList.size()>0){
    		for(FawenAttach attach:attachList){
    			//String[] splits = attach.getAttachname().split("\\.");
    			//String name = splits[0];
    			String name = attach.getAttachType();
    			buffer = buffer.append(name).append("<br/>");
    		}
    	}
    	attachName = buffer.toString();
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			returnItem.setDeptId(this.getLoginUserDepartmentId());
			returnItem.setDelFlag(0);
			returnItemService.save(returnItem);
		}else{
			returnItemService.update(returnItem);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != returnItem)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到returnItem中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			returnItemService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public ReturnItem getReturnItem(){
		return this.returnItem;
	}

	public void setReturnItem(ReturnItem returnItem){
		this.returnItem = returnItem;
	}

	public Zsdw getZsdwxx() {
		return zsdwxx;
	}

	public void setZsdwxx(Zsdw zsdwxx) {
		this.zsdwxx = zsdwxx;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getNo() {
		return No;
	}

	public void setNo(String no) {
		No = no;
	}

	public String getCurrentDate() {
		return currentDate;
	}

	public void setCurrentDate(String currentDate) {
		this.currentDate = currentDate;
	}
       
	public String getAttachName() {
		return attachName;
	}

	public void setAttachName(String attachName) {
		this.attachName = attachName;
	}

    public Lxrinfo getLxrinfo() {
        return lxrinfo;
    }

    public void setLxrinfo(Lxrinfo lxrinfo) {
        this.lxrinfo = lxrinfo;
    }

}
