package com.jshx.returnItem.service;

import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.returnItem.entity.ReturnItem;

public interface ReturnItemService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ReturnItem getById(String id);
	
	/**
	 * 根据项目表主键查询信息
	 * @param xmbzj 项目表主键
	 * @return 
	 */
	public ReturnItem getByXmbzj(String xmbzj);

	/**
	 * 根据项目表主键查询项目挂起已结束的退件信息
	 * @param xmbzj
	 * @return
	 */
	public ReturnItem getByXmbzjWithGQEnd(String xmbzj);
	
	/**
	 * 根据项目表主键查询项目作废已结束的退件信息
	 * @param xmbzj
	 * @return
	 */
	public ReturnItem getByXmbzjWithZFEnd(String xmbzj);
	
	public ReturnItem getByXmbzjAndProcessInsId(String xmbzj,String processInsId);
	
	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(ReturnItem model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(ReturnItem model);

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id);
	
	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
}
