package com.jshx.pzmx.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

import com.jshx.billManager.entity.Indeticur;
import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.HibernateUtil;
import com.jshx.pzmx.entity.Pzmx;
import com.jshx.pzmx.dao.PzmxDao;

@Component("pzmxDao")
public class PzmxDaoImpl extends BaseDaoImpl implements PzmxDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPzmxByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPzmx(Map<String, Object> paraMap){
		return this.findListByHqlId("findPzmxByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Pzmx getById(String id)
	{
		return (Pzmx)this.getObjectById(Pzmx.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Pzmx pzmx)
	{
		pzmx.setId(null);
		this.saveOrUpdateObject(pzmx);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Pzmx pzmx)
	{
		this.saveOrUpdateObject(pzmx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Pzmx.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Pzmx pzmx = (Pzmx)this.getObjectById(Pzmx.class, id);
		pzmx.setDelFlag(1);
		this.saveObject(pzmx);
	}

	@Override
	public void batchupdate(List<Pzmx> list) {

	    Session session = null;  
        if (list != null && list.size() > 0) {  
            try {  
                session = HibernateUtil.getSession();   
                session.beginTransaction(); 
                Pzmx pzmx = null; 
               
                for (int i = 0; i < list.size(); i++) {  
                	pzmx = list.get(i); 
                    session.saveOrUpdate(pzmx); 
                    if (i % 100 == 0) {  
                        session.flush();  
                        session.clear();  
                    }  
                }  
                session.getTransaction().commit(); // 提交事物  
            } catch (Exception e) {  
                e.printStackTrace(); // 打印错误信息  
                session.getTransaction().rollback(); // 出错将回滚事物  
            } 
        }  
    
		
	}

	@Override
	public Pzmx findPzmxByNo(Map<String, Object> paraMap) {
		List list = this.findListByHqlId("findPzmxByMap", paraMap);
		
		if(list.size()>0)
		{
			Pzmx   pzmx = (Pzmx)list.get(0);
			return pzmx;
		}
		return null;
	}

	@Override
	public int findcountByMap(Map<String, Object> paraMap) {
		List list = this.findListByHqlId("findPzmxByMap", paraMap);
		return list.size();
	}
}
