package com.jshx.printhis.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.printhis.entity.PrintHis;
import com.jshx.printhis.dao.PrintHisDao;

@Component("printHisDao")
public class PrintHisDaoImpl extends BaseDaoImpl implements PrintHisDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPrintHisByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPrintHis(Map<String, Object> paraMap){
		return this.findListByHqlId("findPrintHisByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PrintHis getById(String id)
	{
		return (PrintHis)this.getObjectById(PrintHis.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PrintHis printHis)
	{
		printHis.setId(null);
		this.saveOrUpdateObject(printHis);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PrintHis printHis)
	{
		this.saveOrUpdateObject(printHis);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(PrintHis.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		PrintHis printHis = (PrintHis)this.getObjectById(PrintHis.class, id);
		printHis.setDelFlag(1);
		this.saveObject(printHis);
	}
}
