package com.jshx.pjjx.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.fr.stable.core.UUID;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.service.BillManagerService;
import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.DateUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.jtqd.entity.Jtqd;
import com.jshx.jtqd.service.JtqdService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.pjjx.entity.Pjjx;
import com.jshx.pjjx.service.PjjxService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;

public class PjjxAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String startNo;
	private String endNo;
	
	private String idss;
	private String pljxrq;
	
	

	public String getIdss() {
		return idss;
	}

	public void setIdss(String idss) {
		this.idss = idss;
	}

	public String getPljxrq() {
		return pljxrq;
	}

	public void setPljxrq(String pljxrq) {
		this.pljxrq = pljxrq;
	}

	public String getStartNo() {
		return startNo;
	}

	public void setStartNo(String startNo) {
		this.startNo = startNo;
	}

	public String getEndNo() {
		return endNo;
	}

	public void setEndNo(String endNo) {
		this.endNo = endNo;
	}

	/**
	 * 实体类
	 */
	private Pjjx pjjx = new Pjjx();

	/**
	 * 业务类
	 */
	@Autowired
	private PjjxService pjjxService;
	@Autowired
	private JtqdService jtqdService;
	@Autowired
	private PaymentVoucherHisService paymentVoucherHisService;
	@Autowired
	private BillManagerService billManagerService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private PaymentItemDelayService paymentItemDelayService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	public String execute()
	{
		
		return SUCCESS;
	}
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();		
		List<Pjjx> pjjxList = new ArrayList<Pjjx>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		
		paraMap.put("startNO", startNo);
		paraMap.put("endNo", endNo);
		pagination = paymentVoucherHisService.findByPage(pagination, paraMap);
		List<PaymentVoucherHis> list = pagination.list;
		int totalcount = pagination.getTotalCount();
		for(PaymentVoucherHis paymentVoucherHis:list)
		{
			paraMap.put("no", paymentVoucherHis.getVoucherCode());
			paraMap.put("isrece",1);
			Indeticur indeticur = billManagerService.findIndeticurByNo(paraMap);
			Pjjx p = new Pjjx();
			p.setPjbm(paymentVoucherHis.getVoucherCode());
			p.setKpdate(paymentVoucherHis.getPrintDate());
			p.setJbr(paymentVoucherHis.getOperator());
			p.setJkrqc(paymentVoucherHis.getPayerName());
			p.setSalary(paymentVoucherHis.getAmount());
			p.setState(paymentVoucherHis.getApplyStatus());
			p.setSlbh(paymentVoucherHis.getOrderId());
			if(indeticur!=null)
			{
				p.setRkdate(indeticur.getRkTime());
			}
			p.setId(paymentVoucherHis.getId());
			pjjxList.add(p);
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|pjbm|kpdate|jbr|jkrqc|salary|rkdate|state|slbh|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		
		pagination = pjjxService.findByPage(pagination, paraMap);
		pagination.list=pjjxList;
		pagination.setTotalCount(totalcount);
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public void view() throws Exception{
		//if((null != pjjx)&&(null != pjjx.getId()))
		//	pjjx = pjjxService.getById(pjjx.getId());
		//return VIEW;
		try{
		Map<String, Object> paraMap = new HashMap<String, Object>();		
		PaymentVoucherHis	paymentVoucherHis =paymentVoucherHisService.getById(ids);
		if(paymentVoucherHis!=null)
		{
			paraMap.put("no", paymentVoucherHis.getVoucherCode());
			paraMap.put("isrece",1);
			Indeticur indeticur = billManagerService.findIndeticurByNo(paraMap);
			pjjx.setDeptId(this.getLoginUserDepartmentId());
			pjjx.setDelFlag(0);
			pjjx.setPjbm(paymentVoucherHis.getVoucherCode());
			pjjx.setKpdate(paymentVoucherHis.getPrintDate());
			pjjx.setJbr(paymentVoucherHis.getOperator());
			pjjx.setJkrqc(paymentVoucherHis.getPayerName());
			pjjx.setSalary(paymentVoucherHis.getAmount());
			pjjx.setState(paymentVoucherHis.getApplyStatus());
			pjjx.setRkdate(indeticur.getRkTime());
			pjjx.setSlbh(paymentVoucherHis.getOrderId());
			pjjxService.save(pjjx);
			indeticur.setIsrece(0);
			this.getResponse().getWriter().println("{\"result\":true}");
		}
		}catch(Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		//view();
		Indeticur indeticur = billManagerService.getIndeticurById(ids);
		PaymentVoucherHis	paymentVoucherHis =paymentVoucherHisService.getByVoucherCode(indeticur.getNo());
		if(paymentVoucherHis!=null)
		{
			Xmxxb xmxxb = xmxxbService.getBySlbh(paymentVoucherHis.getOrderId());
			pjjx.setPjbm(paymentVoucherHis.getVoucherCode());
			pjjx.setKpdate(paymentVoucherHis.getPrintDate());
			pjjx.setJbr(paymentVoucherHis.getOperator());
			pjjx.setJkrqc(paymentVoucherHis.getPayerName());
			pjjx.setSalary(paymentVoucherHis.getAmount());
			pjjx.setSlbh(paymentVoucherHis.getOrderId());
			pjjx.setPayITEMid(paymentVoucherHis.getRelateId());
			pjjx.setDwdm(paymentVoucherHis.getDwdm());//征收代码
			if(xmxxb!=null)
			{
				pjjx.setZsfw(xmxxb.getZsfw());
			}
			//pjjx.setState(paymentVoucherHis.getApplyStatus());
			pjjx.setZsdw(indeticur.getZsdw());
		}
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
 		if ("add".equalsIgnoreCase(this.flag)){
			pjjx.setDeptId(this.getLoginUserDepartmentId());
			pjjx.setDelFlag(0);
			SimpleDateFormat df=new SimpleDateFormat("yyyy-MM");  
			Date d =df.parse(pjjx.getRkdate());
			Calendar cal=Calendar.getInstance();  
			cal.setTime(d);
			int month = cal.get(Calendar.MONTH)+1;
			if(month == 1 || month ==2 || month ==3){
				pjjx.setSeason(pjjx.getRkdate().substring(0, 4)+ "年01季度");
	        }
	        else if(month == 4 || month ==5 || month ==6){
	        	pjjx.setSeason(pjjx.getRkdate().substring(0, 4)+ "年02季度");
	        }
	        else if(month == 7 || month ==8 || month ==9){
	        	pjjx.setSeason(pjjx.getRkdate().substring(0, 4)+ "年03季度");
	        }
	        else if(month == 10 || month ==11 || month ==12){
	        	pjjx.setSeason(pjjx.getRkdate().substring(0, 4)+ "年04季度");
	        }
			
			pjjxService.save(pjjx);
			Indeticur indeticur = billManagerService.getIndeticurById(ids);
			indeticur.setState("1");
			billManagerService.update(indeticur);
			PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getByVoucherCode(pjjx.getPjbm());
			if(null != paymentVoucherHis){
				//将票据状态置为已缴销，防止前端将已缴销的项目作废
				paymentVoucherHis.setDestroyStatus(Constant.VOUCHER_DESTROY_STATUS_1);
				paymentVoucherHisService.update(paymentVoucherHis);
			}
			 Jtqd tfqd=new Jtqd();
             tfqd.setDelFlag(0);
             tfqd.setSlbh(pjjx.getSlbh());
             tfqd.setSequenceId(UUID.randomUUID().toString().replaceAll("-", ""));
            //.setIszd();
             tfqd.setPzlx("0");
             tfqd.setSalary(pjjx.getSalary());
             Xmxxb xmxxb = xmxxbService.getBySlbh(pjjx.getSlbh());
             if(xmxxb!=null)
             {
             tfqd.setXmmc(xmxxb.getXmmc());
             tfqd.setZsdw(xmxxb.getZsdw());
             tfqd.setZsdm(xmxxb.getDwdm());
             }else
             {
            	 PaymentItemDelay  PaymentItemDelay = paymentItemDelayService.getBySlbh(pjjx.getSlbh());
            	 if(PaymentItemDelay!=null)
            	 {
            	 tfqd.setXmmc(PaymentItemDelay.getXmmc());
                 tfqd.setZsdw(PaymentItemDelay.getZsdw());
                 tfqd.setZsdm(PaymentItemDelay.getDwdm());
            	 }
             }
             tfqd.setRkdate(pjjx.getRkdate());
             jtqdService.save(tfqd);
		}else{
			pjjxService.update(pjjx);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != pjjx)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到pjjx中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			pjjxService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	/**
	 * 批量缴销
	 */
	public String pljx() throws Exception{
		try{
			   String[] idArray = idss.split("\\|");
				if(null != idArray)
				{
					for(String id : idArray)
					{
						Pjjx pjj=new Pjjx();
						Indeticur indeticur = billManagerService.getIndeticurById(id);
						PaymentVoucherHis	paymentVoucherHis =paymentVoucherHisService.getByVoucherCode(indeticur.getNo());
						if(paymentVoucherHis!=null)
						{
							Xmxxb xmxxb = xmxxbService.getBySlbh(paymentVoucherHis.getOrderId());
							pjj.setPjbm(paymentVoucherHis.getVoucherCode());
//							pjj.setKpdate(paymentVoucherHis.getPrintDate());
//							pjj.setJbr(paymentVoucherHis.getOperator());
//							pjj.setJkrqc(paymentVoucherHis.getPayerName());
							pjj.setSalary(paymentVoucherHis.getAmount());
							pjj.setSlbh(paymentVoucherHis.getOrderId());
							pjj.setPayITEMid(paymentVoucherHis.getRelateId());
							if(xmxxb!=null)
							{
								pjj.setZsfw(xmxxb.getZsfw());
								pjj.setDwdm(xmxxb.getDwdm());
							}
							
							pjj.setRkdate(pljxrq);
							//pjjx.setState(paymentVoucherHis.getApplyStatus());
							pjj.setZsdw(indeticur.getZsdw());
						}
						
						pjj.setDeptId(this.getLoginUserDepartmentId());
						pjj.setDelFlag(0);
						SimpleDateFormat df=new SimpleDateFormat("yyyy-MM");  
						Date d =df.parse(pjj.getRkdate());
						Calendar cal=Calendar.getInstance();  
						cal.setTime(d);
						int month = cal.get(Calendar.MONTH)+1;
						if(month == 1 || month ==2 || month ==3){
							pjj.setSeason(pjj.getRkdate().substring(0, 4)+ "年01季度");
				        }
				        else if(month == 4 || month ==5 || month ==6){
				        	pjj.setSeason(pjj.getRkdate().substring(0, 4)+ "年02季度");
				        }
				        else if(month == 7 || month ==8 || month ==9){
				        	pjj.setSeason(pjj.getRkdate().substring(0, 4)+ "年03季度");
				        }
				        else if(month == 10 || month ==11 || month ==12){
				        	pjj.setSeason(pjj.getRkdate().substring(0, 4)+ "年04季度");
				        }
						pjj.setId("");
						pjj.setCreateUserID("");
						pjj.setUpdateUserID("");
						pjj.setState("");
						pjjxService.save(pjj);
						indeticur.setState("1");
						billManagerService.update(indeticur);
//						PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getByVoucherCode(pjj.getPjbm());
						if(null != paymentVoucherHis){
							//将票据状态置为已缴销，防止前端将已缴销的项目作废
							paymentVoucherHis.setDestroyStatus(Constant.VOUCHER_DESTROY_STATUS_1);
							paymentVoucherHisService.update(paymentVoucherHis);
						}
						 Jtqd tfqd=new Jtqd();
			             tfqd.setDelFlag(0);
			             tfqd.setSlbh(pjj.getSlbh());
			             tfqd.setSequenceId(UUID.randomUUID().toString().replaceAll("-", ""));
			            //.setIszd();
			             tfqd.setPzlx("0");
			             tfqd.setSalary(pjj.getSalary());
			             Xmxxb xmxxb = xmxxbService.getBySlbh(pjj.getSlbh());
			             if(xmxxb!=null)
			             {
			             tfqd.setXmmc(xmxxb.getXmmc());
			             tfqd.setZsdw(xmxxb.getZsdw());
			             tfqd.setZsdm(xmxxb.getDwdm());
			             }else
			             {
			            	 PaymentItemDelay  PaymentItemDelay = paymentItemDelayService.getBySlbh(pjj.getSlbh());
			            	 if(PaymentItemDelay!=null)
			            	 {
			            	 tfqd.setXmmc(PaymentItemDelay.getXmmc());
			                 tfqd.setZsdw(PaymentItemDelay.getZsdw());
			                 tfqd.setZsdm(PaymentItemDelay.getDwdm());
			            	 }
			             }
			             tfqd.setRkdate(pjj.getRkdate());
			             jtqdService.save(tfqd);
					}
				}
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Pjjx getPjjx(){
		return this.pjjx;
	}

	public void setPjjx(Pjjx pjjx){
		this.pjjx = pjjx;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }


  
    
}
