package com.jshx.paymentItemHis.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemPending.entity.PaymentItemPending;

public interface PaymentItemHisService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public Pagination findPaymentItemHisJoinXmxxbByMap(Pagination page, Map<String, Object> paraMap);

	public List<PaymentItemHis> findall( Map<String, Object> paraMap);
	public List<PaymentItemHis> findsuoyou( Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemHis getById(String id);
	
	/**根据受理编号查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public PaymentItemHis getByOrderId(String orderId);
	
	/**根据项目表id查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public PaymentItemHis getByXmbId(String xmbzj);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentItemHis model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentItemHis model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
	
	
	/**根据凭证查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public PaymentItemHis getByZslxdbh(String zslxdbh);

	/**
	 * 获取上一个凭证号，去最大值
	 * @return
	 */
	public String getLastZslxdbh();

	public int getPzbh();
}
