package com.jshx.mjyj.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.mjyj.entity.Mjyj;
import com.jshx.mjyj.dao.MjyjDao;

@Component("mjyjDao")
public class MjyjDaoImpl extends BaseDaoImpl implements MjyjDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findMjyjByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findMjyj(Map<String, Object> paraMap){
		return this.findListByHqlId("findMjyjByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Mjyj getById(String id)
	{
		return (Mjyj)this.getObjectById(Mjyj.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Mjyj mjyj)
	{
		mjyj.setId(null);
		this.saveOrUpdateObject(mjyj);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Mjyj mjyj)
	{
		this.saveOrUpdateObject(mjyj);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Mjyj.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Mjyj mjyj = (Mjyj)this.getObjectById(Mjyj.class, id);
		mjyj.setDelFlag(1);
		this.saveObject(mjyj);
	}
}
