package com.jshx.lxrinfo.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.lxrinfo.dao.LxrinfoDao;
import com.jshx.lxrinfo.entity.Lxrinfo;
import com.jshx.lxrinfo.service.LxrinfoService;

@Service("lxrinfoService")
public class LxrinfoServiceImpl extends BaseServiceImpl implements LxrinfoService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("lxrinfoDao")
	private LxrinfoDao lxrinfoDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return lxrinfoDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Lxrinfo getById(String id)
	{
		return lxrinfoDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Lxrinfo lxrinfo)
	{
		lxrinfoDao.save(lxrinfo);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Lxrinfo lxrinfo)
	{
		lxrinfoDao.update(lxrinfo);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=lxrinfoDao.findLxrinfo(paraMap);
		
		lxrinfoDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    lxrinfoDao.deleteWithFlag(id);
			}
		}
	}

	
    @Transactional
    public Lxrinfo getBybhdwdm(String bh, String dwdm) {
        // TODO Auto-generated method stub
        Map<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("lxbm", "%"+bh+"%");
        paraMap.put("dwdm", "%"+dwdm+"%");
        paraMap.put("syzt", "%0%");
        List<Lxrinfo> objects=lxrinfoDao.findLxrinfo(paraMap);
        if(null!=objects&&objects.size()>0){
            return objects.get(0);
        }else{
            Map<String, Object> paraMap1 = new HashMap<String, Object>();
            paraMap1.put("lxbm", "%999%");
            paraMap1.put("dwdm", "%"+dwdm+"%");
            paraMap1.put("syzt", "%0%");
            List<Lxrinfo> moren=lxrinfoDao.findLxrinfo(paraMap1);
            if(null!=moren&&moren.size()>0){
                return moren.get(0);
            }
        }
        Lxrinfo a=new Lxrinfo();
        a.setLxr("");
        a.setLxdh("");
        a.setJddh("");
        return a;
    }
}
