package com.jshx.jtqd.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.pjjx.entity.Pjjx;
import com.jshx.pjjx.service.PjjxService;
import com.jshx.recordvoucher.entity.RecodeVoucher;
import com.jshx.recordvoucher.service.RecodeVoucherService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.jtqd.entity.Jtqd;
import com.jshx.jtqd.service.JtqdService;

public class JtqdAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Jtqd jtqd = new Jtqd();

	/**
	 * 业务类
	 */
	@Autowired
	private JtqdService jtqdService;
	@Autowired
	private PjjxService pjjxService;
	@Autowired
	private PaymentVoucherHisService paymentVoucherHisService;
	@Autowired
        private RecodeVoucherService recodeVoucherService;
	@Autowired
	private XmxxbService xmxxbService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != jtqd){
		   if(StringUtils.isNotEmpty(jtqd.getSlbh()))
		   {
			   paraMap.put("slbh", jtqd.getSlbh());
		   }
		   if(StringUtils.isNotEmpty(jtqd.getXmmc()))
		   {
			   paraMap.put("xmmc", "%"+jtqd.getXmmc()+"%");
		   }
		   if(StringUtils.isNotEmpty(jtqd.getRkdate()))
		   {
			   paraMap.put("rkdate", "%"+jtqd.getRkdate()+"%");
		   }
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|slbh|pzlx|iszd|xmmc|zsdw|sequenceId|dwmc|salary|zsfw|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = jtqdService.findByPage(pagination, paraMap);
		List<Jtqd> ljs=pagination.list;
		    if(null!=ljs&&ljs.size()>0){
		        for (Jtqd jtqd : ljs) {
                           Map<String, Object> paraMap1 = new HashMap<String, Object>();
                           paraMap1.put("slbh", jtqd.getSlbh());
                           List<Xmxxb> lx =xmxxbService.findXmxxb(paraMap1);
                           if(null!=lx&&lx.size()>0){
                        	   jtqd.setDwmc(lx.get(0).getJsdw()); 
                        	   jtqd.setZsfw(lx.get(0).getZsfw());
                           }
                        }
		         }
		
		convObjectToJson(pagination, config);
	}
	
	
	
	public void list1() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != jtqd){
		   if(StringUtils.isNotEmpty(jtqd.getSlbh()))
		   {
			   paraMap.put("slbh", jtqd.getSlbh());
		   }
		   if(StringUtils.isNotEmpty(jtqd.getXmmc()))
		   {
			   paraMap.put("xmmc", "%"+jtqd.getXmmc()+"%");
		   }
		   if(StringUtils.isNotEmpty(jtqd.getLsyjzh()))
		   {
		       List slbhs=new ArrayList<>();
		       Map<String, Object> paraMap222 = new HashMap<String, Object>();
		       paraMap222.put("slate", "%"+jtqd.getLsyjzh()+"%");
		       List<RecodeVoucher> lrs=recodeVoucherService.findall(paraMap222);
		       if(null!=lrs&&lrs.size()>0){
		           for (RecodeVoucher re : lrs) {
		               slbhs.add(re.getSequenctId());
                        }
		       }
		       paraMap.put("seqlis", slbhs);
		   }
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|slbh|pzlx|iszd|xmmc|zsdw|sequenceId|lsyjzh|zdriqi|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = jtqdService.findByPage1(pagination, paraMap);
		List<Jtqd> ljs=pagination.list;
		    if(null!=ljs&&ljs.size()>0){
		        for (Jtqd jtqd : ljs) {
		            RecodeVoucher recodeVoucher=new RecodeVoucher();
		            recodeVoucher = recodeVoucherService.getByslbh(jtqd.getSequenceId(), "0");
		            jtqd.setLsyjzh(recodeVoucher.getSlate());
		            jtqd.setZdriqi(recodeVoucher.getZdDate());
                        }
		    }
		convObjectToJson(pagination, config);
	}
	public void isExit()
	{
		 JSONObject jsonObject = new JSONObject();
		
		try {
			getResponse().setContentType("application/json;charset=UTF-8");
			getResponse().setCharacterEncoding("utf-8");
			getResponse().setHeader("Charset", "utf-8");
			getResponse().setHeader("Cache-Control", "no-cache");
			PaymentVoucherHis his = paymentVoucherHisService.getPayMentByorderId(ids);
			if(his==null)
			{
				jsonObject.put("status", "y");
			}else
			{
				jsonObject.put("status", "n");
			}
			getResponse().getWriter().println(jsonObject.toString());	
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != jtqd)&&(null != jtqd.getId()))
			jtqd = jtqdService.getById(jtqd.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		//view();
		Pjjx pjjx = pjjxService.getPjjxBySlbh(ids);
	    return EDIT;
	}
	public String initEdit2() throws Exception{
	    //view();
	    jtqd = jtqdService.getById(ids);
	    RecodeVoucher recodeVoucher=new RecodeVoucher();
            recodeVoucher = recodeVoucherService.getByslbh(jtqd.getSequenceId(), "0");
            jtqd.setLsyjzh(recodeVoucher.getSlate());
             jtqd.setZdriqi(recodeVoucher.getZdDate());
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			jtqd.setDeptId(this.getLoginUserDepartmentId());
			jtqd.setDelFlag(0);
			jtqdService.save(jtqd);
		}else{
			jtqdService.update(jtqd);
		}
		
		return RELOAD;
	}
	public String xgjzh() throws Exception{
	    RecodeVoucher    recodeVoucher = recodeVoucherService.getByslbh(jtqd.getSequenceId(), "0");
	    RecodeVoucher recodeVoucher1 = recodeVoucherService.getByslbh(jtqd.getSequenceId(), "1");
	    recodeVoucher.setSlate(jtqd.getLsyjzh());
	    recodeVoucher1.setSlate(jtqd.getLsyjzh());
	    recodeVoucherService.update(recodeVoucher);
	    recodeVoucherService.update(recodeVoucher1);
	    return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != jtqd)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到jtqd中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			jtqdService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Jtqd getJtqd(){
		return this.jtqd;
	}

	public void setJtqd(Jtqd jtqd){
		this.jtqd = jtqd;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
}
