package com.jshx.hsdmj.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hsdmj.dao.HsdmjDao;
import com.jshx.hsdmj.entity.Hsdmj;
import com.jshx.hsdmj.service.HsdmjService;

@Service("hsdmjService")
public class HsdmjServiceImpl extends BaseServiceImpl implements HsdmjService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("hsdmjDao")
	private HsdmjDao hsdmjDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hsdmjDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hsdmj getById(String id)
	{
		return hsdmjDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hsdmj hsdmj)
	{
		hsdmjDao.save(hsdmj);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hsdmj hsdmj)
	{
		hsdmjDao.update(hsdmj);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list = Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = hsdmjDao.findHsdmj(paraMap);

		hsdmjDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		String[] idArray = ids.split("\\|");
		if (null != idArray)
		{
			for (String id : idArray)
			{
				if (id != null && !id.trim().equals(""))
					hsdmjDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Hsdmj> query(Map<String, Object> map)
	{
		return hsdmjDao.findHsdmj(map);
	}

	@Override
	@Transactional
	public void delBySlbh(String slbh)
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", slbh);
		List objects = hsdmjDao.findHsdmj(paraMap);
		hsdmjDao.removeAll(objects);
	}
}
