package com.jshx.hisxrspjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrspjlb.entity.Hisxrspjlb;
import com.jshx.hisxrspjlb.dao.HisxrspjlbDao;

@Component("hisxrspjlbDao")
public class HisxrspjlbDaoImpl extends BaseDaoImpl implements HisxrspjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxrspjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxrspjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxrspjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrspjlb getById(String id)
	{
		return (Hisxrspjlb)this.getObjectById(Hisxrspjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxrspjlb hisxrspjlb)
	{
		hisxrspjlb.setId(null);
		this.saveOrUpdateObject(hisxrspjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxrspjlb hisxrspjlb)
	{
		this.saveOrUpdateObject(hisxrspjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxrspjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxrspjlb hisxrspjlb = (Hisxrspjlb)this.getObjectById(Hisxrspjlb.class, id);
		hisxrspjlb.setDelFlag(1);
		this.saveObject(hisxrspjlb);
	}
}
