package com.jshx.hissfxxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hissfxxb.entity.Hissfxxb;
import com.jshx.hissfxxb.dao.HissfxxbDao;

@Component("hissfxxbDao")
public class HissfxxbDaoImpl extends BaseDaoImpl implements HissfxxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHissfxxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHissfxxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHissfxxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hissfxxb getById(String id)
	{
		return (Hissfxxb)this.getObjectById(Hissfxxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hissfxxb hissfxxb)
	{
		hissfxxb.setId(null);
		this.saveOrUpdateObject(hissfxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hissfxxb hissfxxb)
	{
		this.saveOrUpdateObject(hissfxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hissfxxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hissfxxb hissfxxb = (Hissfxxb)this.getObjectById(Hissfxxb.class, id);
		hissfxxb.setDelFlag(1);
		this.saveObject(hissfxxb);
	}

	@Override
	public List<String> findcd(Map<String, Object> paraMap) {
	
		return  this.findListBySqlId("findcd1", paraMap);
	}
}
