package com.jshx.hishxddfs.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxddfs.entity.Hishxddfs;
import com.jshx.hishxddfs.dao.HishxddfsDao;

@Component("hishxddfsDao")
public class HishxddfsDaoImpl extends BaseDaoImpl implements HishxddfsDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHishxddfsByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHishxddfs(Map<String, Object> paraMap){
		return this.findListByHqlId("findHishxddfsByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxddfs getById(String id)
	{
		return (Hishxddfs)this.getObjectById(Hishxddfs.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hishxddfs hishxddfs)
	{
		hishxddfs.setId(null);
		this.saveOrUpdateObject(hishxddfs);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hishxddfs hishxddfs)
	{
		this.saveOrUpdateObject(hishxddfs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hishxddfs.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hishxddfs hishxddfs = (Hishxddfs)this.getObjectById(Hishxddfs.class, id);
		hishxddfs.setDelFlag(1);
		this.saveObject(hishxddfs);
	}
}
