package com.jshx.fawen.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.entity.FawenReceiveinfo;

public interface FawenReceiveinfoService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	
	
	
	public List findByList(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public FawenReceiveinfo getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(FawenReceiveinfo model);
	
	
	/**
	 * 批量保存信息
	 * @param model 信息
	 */
	public void saveCollection(Collection<FawenReceiveinfo> receiveList);
	
	

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(FawenReceiveinfo model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

	public List<Object> queryQianshouList(Map<String, String> paramMap);

	/**
	 * 查询当前用户接收的未读文件
	 * @param  userid, recevestate(接收状态 )
	 */
	public List findnotReadInfo(Map<String, String> paramMap);

	public FawenReceiveinfo oaReceiveinfo_recieverList(Map<String, String> paramMap);



	public void deleteByEmailId(Map<String, Object> map);
	
}
