package com.jshx.common.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.common.dao.CommonDao;
import com.jshx.common.service.CommonService;
import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;

@Service("commonService")
public class CommonServiceImpl extends BaseServiceImpl implements CommonService{
	
	@Autowired
	@Qualifier("commonDao")
	private CommonDao commonDao;
	
	@Override
	@Transactional
	public List findListBySqlId(String sqlId,Map<String, Object> paraMap) {
		return commonDao.findListBySqlId(sqlId, paraMap);
	}

	@Override
	@Transactional
	public Pagination findBySqlId(String sqlId,	Map<String, Object> paraMap,Pagination pagination) {
		return commonDao.findPageBySqlIdReturnMap(sqlId, paraMap, pagination);
	}
}
